/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.provider;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.provider.TransientReqIFItemProvider;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.rmf.reqif10.provider.IdentifiableTest;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpecElementWithAttributesTest
extends IdentifiableTest {
    protected static final String[] STANDARD_PROPERTIES = new String[]{"Desc", "Identifier", "Last Change", "Long Name", "Type"};

    protected abstract void addFixtureToReqIf(ReqIF var1);

    protected SpecElementWithAttributes getFixture() {
        return (SpecElementWithAttributes)this.fixture;
    }

    @Test
    public void testSpecElementNotificationValueAdded() {
        ItemProviderAdapter itemProvider = this.getItemProvider(this.getFixture());
        itemProvider.addListener(this.listener);
        AttributeValueString av = ReqIF10Factory.eINSTANCE.createAttributeValueString();
        this.getFixture().getValues().add((Object)av);
        Assert.assertEquals((long)1L, (long)this.notifications.size());
        Assert.assertSame((Object)this.getFixture(), (Object)((Notification)this.notifications.get(0)).getNotifier());
        Assert.assertEquals((Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)((Notification)this.notifications.get(0)).getFeature());
    }

    @Test
    public void testSpecElementNotificationValueChanged() {
        ItemProviderAdapter itemProvider = this.getItemProvider(this.getFixture());
        itemProvider.addListener(this.listener);
        AttributeValueString av = ReqIF10Factory.eINSTANCE.createAttributeValueString();
        this.getFixture().getValues().add((Object)av);
        this.notifications.clear();
        ProrUtil.setTheValue((AttributeValue)((AttributeValue)this.getFixture().getValues().get(0)), (Object)"newDescription", (EditingDomain)this.editingDomain);
        Assert.assertEquals((long)2L, (long)this.notifications.size());
        Assert.assertSame((Object)this.getFixture(), (Object)((Notification)this.notifications.get(0)).getNotifier());
        Assert.assertEquals((Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)((Notification)this.notifications.get(0)).getFeature());
        Assert.assertEquals((long)1L, (long)((Notification)this.notifications.get(0)).getEventType());
    }

    @Test
    public void testSpecElementTypeValuesSynced() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.addFixtureToReqIf(reqif);
        Assert.assertEquals((long)0L, (long)this.getFixture().getValues().size());
        this.getItemProvider(this.getFixture()).addListener(this.listener);
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        this.setSpecTypeWithAttributeOnFixture(reqif, (AttributeDefinition)ad);
        SpecType type = ReqIF10Util.getSpecType((AttributeDefinition)ad);
        Assert.assertSame((Object)type, (Object)ReqIF10Util.getSpecType((SpecElementWithAttributes)this.getFixture()));
        Assert.assertEquals((long)0L, (long)this.getFixture().getValues().size());
        Assert.assertEquals((long)1L, (long)this.notifications.size());
        Assert.assertEquals((Object)this.getFixture(), (Object)((Notification)this.notifications.get(0)).getNotifier());
    }

    @Test
    public void testSpecElementAttributeDefinitionChanged() throws URISyntaxException {
        ReqIF reqif = ReqIF10Factory.eINSTANCE.createReqIF();
        ReqIFContent content = ReqIF10Factory.eINSTANCE.createReqIFContent();
        reqif.setCoreContent(content);
        this.addFixtureToReqIf(reqif);
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        this.setSpecTypeWithAttributeOnFixture(reqif, (AttributeDefinition)ad);
        this.getItemProvider(this.getFixture()).addListener(this.listener);
        Assert.assertEquals((long)0L, (long)this.notifications.size());
        this.setViaCommand(ad, (EStructuralFeature)ReqIF10Package.Literals.IDENTIFIABLE__LONG_NAME, "New Name");
        Assert.assertEquals((Object)"New Name", (Object)ad.getLongName());
        Assert.assertEquals((long)1L, (long)this.notifications.size());
        Assert.assertEquals((Object)this.getFixture(), (Object)((Notification)this.notifications.get(0)).getNotifier());
    }

    @Test
    public void testSpecTypeChangeNotifications() {
        ReqIF reqif = ReqIF10Factory.eINSTANCE.createReqIF();
        ReqIFContent content = ReqIF10Factory.eINSTANCE.createReqIFContent();
        reqif.setCoreContent(content);
        this.addFixtureToReqIf(reqif);
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        this.setSpecTypeWithAttributeOnFixture(reqif, (AttributeDefinition)ad);
        SpecType type = ReqIF10Util.getSpecType((AttributeDefinition)ad);
        ItemProviderAdapter ip = this.getItemProvider(this.getFixture());
        ip.addListener(this.listener);
        AttributeDefinitionString ad2 = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        this.setViaCommand(type, (EStructuralFeature)ReqIF10Package.Literals.SPEC_TYPE__SPEC_ATTRIBUTES, ad2);
        Assert.assertEquals((long)1L, (long)this.notifications.size());
    }

    @Test
    public void testSpecElementTypeChangedWithoutAttributes() {
        ReqIF reqif = ReqIF10Factory.eINSTANCE.createReqIF();
        ReqIFContent content = ReqIF10Factory.eINSTANCE.createReqIFContent();
        reqif.setCoreContent(content);
        this.addFixtureToReqIf(reqif);
        ItemProviderAdapter ip = this.getItemProvider(this.getFixture());
        ip.addListener(this.listener);
        SpecType specTypeExpected = this.setSpecTypeWithoutAttributeOnFixture(reqif);
        SpecType specTypeActual = ReqIF10Util.getSpecType((SpecElementWithAttributes)this.getFixture());
        Assert.assertSame((Object)specTypeExpected, (Object)specTypeActual);
        Assert.assertEquals((long)1L, (long)this.notifications.size());
    }

    @Test
    public void testDefaultPropertyLabels() {
        List props = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.getFixture()).getPropertyDescriptors((Object)this.getFixture());
        HashSet<String> actual = new HashSet<String>();
        for (IItemPropertyDescriptor prop : props) {
            actual.add(prop.getDisplayName((Object)this.getFixture()));
        }
        Assert.assertEquals(this.getStandardPropertyNames(), actual);
    }

    @Test
    public void testPropertiesOfSpecElementWithAttributeNullLabel() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.addFixtureToReqIf(reqif);
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        this.setSpecTypeWithAttributeOnFixture(reqif, (AttributeDefinition)ad);
        ItemProviderAdapter itemProvider = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.getFixture());
        List props = itemProvider.getPropertyDescriptors((Object)this.getFixture());
        HashSet<String> actual = new HashSet<String>();
        for (IItemPropertyDescriptor prop : props) {
            actual.add(prop.getDisplayName((Object)this.getFixture()));
        }
        Set<String> expected = this.getStandardPropertyNames();
        expected.add("UNNAMED (" + ad.getIdentifier() + ")");
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testPropertiesOfSpecElementWithAttribute() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.addFixtureToReqIf(reqif);
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        ad.setLongName("Description");
        this.setSpecTypeWithAttributeOnFixture(reqif, (AttributeDefinition)ad);
        ItemProviderAdapter itemProvider = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.getFixture());
        List props = itemProvider.getPropertyDescriptors((Object)this.getFixture());
        HashSet<String> actual = new HashSet<String>();
        for (IItemPropertyDescriptor prop : props) {
            actual.add(prop.getDisplayName((Object)this.getFixture()));
        }
        Set<String> expected = this.getStandardPropertyNames();
        expected.add("Description");
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testResetTypeDeletesValues() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.addFixtureToReqIf(reqif);
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        ad.setLongName("Description");
        this.setSpecTypeWithAttributeOnFixture(reqif, (AttributeDefinition)ad);
        AttributeValue av = ReqIF10Util.createAttributeValue((AttributeDefinition)ad);
        this.getFixture().getValues().add((Object)av);
        Assert.assertEquals((long)1L, (long)this.getFixture().getValues().size());
        this.setFixtureType(this.getFixture(), null);
        Assert.assertNull((Object)ReqIF10Util.getSpecType((SpecElementWithAttributes)this.getFixture()));
        Assert.assertEquals((long)0L, (long)this.getFixture().getValues().size());
    }

    @Test
    public void testCreateCommands() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("bare.reqif");
        this.getItemProvider(reqif.getCoreContent()).getChildren((Object)reqif.getCoreContent());
        this.addFixtureToReqIf(reqif);
        TransientReqIFItemProvider ip = (TransientReqIFItemProvider)this.getItemProvider(this.getFixture()).getParent((Object)this.getFixture());
        Collection childDescriptors = ip.getNewChildDescriptors((Object)this.getFixture(), (EditingDomain)this.editingDomain, null);
        Assert.assertEquals((long)1L, (long)childDescriptors.size());
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        this.setSpecTypeWithAttributeOnFixture(reqif, (AttributeDefinition)ad);
        childDescriptors = ip.getNewChildDescriptors((Object)this.getFixture(), (EditingDomain)this.editingDomain, null);
        Assert.assertEquals((long)2L, (long)childDescriptors.size());
    }

    protected abstract Set<String> getStandardPropertyNames();

    protected void setSpecTypeWithAttributeOnFixture(ReqIF reqif, AttributeDefinition ad) {
        SpecType type = this.getSpecTypeInstance();
        this.setViaCommand(type, (EStructuralFeature)ReqIF10Package.Literals.SPEC_TYPE__SPEC_ATTRIBUTES, ad);
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.Literals.REQ_IF_CONTENT__SPEC_TYPES, type);
        this.setFixtureType(this.getFixture(), type);
    }

    protected SpecType setSpecTypeWithoutAttributeOnFixture(ReqIF reqif) {
        SpecType type = this.getSpecTypeInstance();
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.Literals.REQ_IF_CONTENT__SPEC_TYPES, type);
        this.setFixtureType(this.getFixture(), type);
        return type;
    }

    @Test
    public void testThatSpecTypeMattersForPropertyValues() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.setSpecTypeWithoutAttributeOnFixture(reqif);
        ItemProviderAdapter provider = this.getItemProvider(this.getFixture());
        int oldCount = provider.getPropertyDescriptors((Object)this.getFixture()).size();
        AttributeValueString value = ReqIF10Factory.eINSTANCE.createAttributeValueString();
        value.setDefinition((AttributeDefinitionString)((SpecType)reqif.getCoreContent().getSpecTypes().get(0)).getSpecAttributes().get(0));
        this.getFixture().getValues().add((Object)value);
        List descriptors = provider.getPropertyDescriptors((Object)this.getFixture());
        Assert.assertEquals((long)oldCount, (long)descriptors.size());
    }

    protected abstract void setFixtureType(SpecElementWithAttributes var1, SpecType var2);

    protected abstract SpecType getSpecTypeInstance();

    @Override
    protected EObject getParent() {
        return ReqIF10Factory.eINSTANCE.createReqIFContent();
    }
}

