/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parts;

import java.util.Collections;
import java.util.Map;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeCreationTool;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTwoPointCreationTool
extends AspectUnspecifiedTypeCreationTool {
    private static final int STATE_FIRST = 65536;
    public static final String FIRST_TARGET = "FIRST_TARGET";
    public static final String SECOND_TARGET = "SECOND_TARGET";
    protected EditPart first = null;
    protected EditPart second = null;

    public AbstractTwoPointCreationTool(IElementType elementType) {
        super(Collections.singletonList(elementType));
        this.setDefaultCursor(Cursors.CROSS);
        this.setDisabledCursor(Cursors.NO);
    }

    public void activate() {
        super.activate();
        this.first = null;
        this.second = null;
        this.started();
    }

    public void deactivate() {
        super.deactivate();
        AbstractTwoPointCreationTool.setStatusMessage(null);
    }

    protected boolean handleButtonDown(int button) {
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        Command command = this.getCommand();
        EditPart targetEditPart = this.getTargetEditPart();
        if (this.isInState(1) && command.canExecute()) {
            this.first = targetEditPart;
            this.setState(65536);
            this.handleMove();
            this.firstElementSelected();
        } else if (this.isInState(65536) && command.canExecute()) {
            this.second = targetEditPart;
            this.eraseTargetFeedback();
            this.setTargetRequest(this.createTargetRequest());
            this.setCurrentCommand(this.getCommand());
            this.performCreation(button);
            this.handleFinished();
            this.setState(0x40000000);
        }
        return true;
    }

    protected Request createTargetRequest() {
        AspectUnspecifiedTypeCreationTool.CreateAspectUnspecifiedTypeRequest request = new AspectUnspecifiedTypeCreationTool.CreateAspectUnspecifiedTypeRequest(this, this.getElementTypes(), this.getPreferencesHint()){

            protected void createRequests() {
                IElementType elementType = (IElementType)this.getElementTypes().get(0);
                CreateElementRequest createElementRequest = new CreateElementRequest(elementType);
                createElementRequest.setParameter(AbstractTwoPointCreationTool.FIRST_TARGET, (Object)AbstractTwoPointCreationTool.this.first);
                createElementRequest.setParameter(AbstractTwoPointCreationTool.SECOND_TARGET, (Object)AbstractTwoPointCreationTool.this.second);
                CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(createElementRequest), Node.class, this.getGraphicalHint((IHintedType)elementType), this.getPreferencesHint());
                CreateViewAndElementRequest request = new CreateViewAndElementRequest(viewDescriptor);
                request.setExtendedData(this.getExtendedData());
                request.setType(this.getType());
                this.requests.put(elementType, request);
            }
        };
        Map extendedData = request.getExtendedData();
        extendedData.put(FIRST_TARGET, this.first);
        extendedData.put(SECOND_TARGET, this.second);
        return request;
    }

    protected void updateTargetRequest() {
        CreateRequest createRequest = this.getCreateRequest();
        createRequest.setSize(null);
        createRequest.setLocation(this.getLocation());
        createRequest.setSnapToEnabled(false);
    }

    protected boolean handleButtonUp(int button) {
        return false;
    }

    protected boolean handleDrag() {
        return false;
    }

    protected boolean handleDragStarted() {
        return false;
    }

    protected boolean handleDragInProgress() {
        return false;
    }

    protected Command getCommand() {
        EditPart secondTarget;
        EditPart firstTarget;
        CreateRequest request = this.getTargetRequest();
        if (this.isInState(1)) {
            firstTarget = this.getTargetEditPart();
            secondTarget = null;
        } else {
            firstTarget = this.first;
            secondTarget = this.getTargetEditPart();
        }
        if (!this.validateFirstTarget(firstTarget)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (this.isInState(1)) {
            return new Command(){

                public void execute() {
                    throw new IllegalStateException("This dummy command must never be executed");
                }
            };
        }
        if (!this.validateSecondTarget(firstTarget, secondTarget)) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getCommand(firstTarget, secondTarget, (Request)request);
    }

    protected abstract Command getCommand(EditPart var1, EditPart var2, Request var3);

    protected abstract boolean validateFirstTarget(EditPart var1);

    protected abstract boolean validateSecondTarget(EditPart var1, EditPart var2);

    protected abstract void started();

    protected abstract void firstElementSelected();

    protected static void setStatusMessage(String message) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    protected static boolean ordered(EditPart first, EditPart second) {
        int secondIndex;
        if (!(first.getModel() instanceof View) || !(second.getModel() instanceof View)) {
            return false;
        }
        View firstView = (View)first.getModel();
        View secondView = (View)second.getModel();
        if (firstView.eContainer() != secondView.eContainer()) {
            return false;
        }
        View compartment = (View)firstView.eContainer();
        int firstIndex = compartment.getChildren().indexOf((Object)firstView);
        return firstIndex <= (secondIndex = compartment.getChildren().indexOf((Object)secondView));
    }
}

