/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.net4j.db.ddl.IDBNamedElement;
import org.eclipse.net4j.internal.db.ddl.DBElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBNamedElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.util.io.IORuntimeException;

public abstract class DBNamedElement
extends DBElement
implements InternalDBNamedElement {
    private static final long serialVersionUID = 1L;
    private String name;

    public DBNamedElement(String name) {
        this.setName(name);
    }

    protected DBNamedElement() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IDBNamedElement) {
            IDBNamedElement that = (IDBNamedElement)obj;
            return this.name == that.getName();
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String dumpToString() {
        try {
            CharArrayWriter writer = new CharArrayWriter();
            this.dump(writer);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    @Override
    public final void dump() {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(System.out);
            this.dump(writer);
            writer.flush();
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public static <E extends IDBNamedElement> E findElement(InternalDBSchema schema, E[] elements, String name) {
        int i = 0;
        while (i < elements.length) {
            E element = elements[i];
            if (schema.equalNames(element.getName(), name)) {
                return element;
            }
            ++i;
        }
        return null;
    }
}

