/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.view.CDOViewSetImpl;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;

public final class SessionUtil {
    private static final boolean ROOT_RESOURCE_EXCLUSION_CHECK = false;
    private static Runnable testDelayInSessionActivation;
    private static Runnable testDelayInViewActivation;

    private SessionUtil() {
    }

    private static void addRootResourceExclusionCheckAdapter(ResourceSet resourceSet) {
        class RootResourceExclusionCheckAdapter
        extends AdapterImpl {
            RootResourceExclusionCheckAdapter() {
            }

            public void notifyChanged(Notification msg) {
                if (msg.getEventType() == 3 || msg.getEventType() == 5) {
                    Object newValue = msg.getNewValue();
                    this.check(newValue);
                }
            }

            public void setTarget(Notifier newTarget) {
                this.check(newTarget);
            }

            private void check(Object object) {
                if (object instanceof CDOResource && ((CDOResource)object).isRoot()) {
                    throw new AssertionError((Object)"Root resource in resource set not allowed");
                }
            }
        }
        resourceSet.eAdapters().add((Object)new RootResourceExclusionCheckAdapter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalCDOViewSet prepareResourceSet(ResourceSet resourceSet) {
        InternalCDOViewSet viewSet = null;
        ResourceSet resourceSet2 = resourceSet;
        synchronized (resourceSet2) {
            viewSet = (InternalCDOViewSet)CDOUtil.getViewSet((Notifier)resourceSet);
            if (viewSet == null) {
                viewSet = new CDOViewSetImpl();
                resourceSet.eAdapters().add((Object)viewSet);
            }
        }
        return viewSet;
    }

    public static Runnable getTestDelayInSessionActivation() {
        return testDelayInSessionActivation;
    }

    public static void setTestDelayInSessionActivation(Runnable runnable) {
        testDelayInSessionActivation = runnable;
    }

    public static Runnable getTestDelayInViewActivation() {
        return testDelayInViewActivation;
    }

    public static void setTestDelayInViewActivation(Runnable runnable) {
        testDelayInViewActivation = runnable;
    }
}

