/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.xsl.internal.debug.ui.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.ResourceSelectionBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;

public class InputFileBlock
extends ResourceSelectionBlock {
    private final IFile defaultFile;

    public InputFileBlock(IFile defaultFile) {
        super(1, false);
        this.defaultFile = defaultFile;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String path = "";
        if (this.defaultFile != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", this.defaultFile.getFullPath().toPortableString());
        }
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", path);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", null);
            if (wd != null) {
                this.setText(wd);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(Messages.InputFileBlock_Exception_occurred_reading_configuration + e.getStatus().getMessage());
            XSLDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", this.getText());
    }

    public String getName() {
        return Messages.InputFileBlock_Name;
    }

    @Override
    protected void textModified() {
        String workingDirPath = this.getText();
        if (workingDirPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
                new Path(manager.performStringSubstitution(workingDirPath));
            }
            catch (CoreException coreException) {}
        } else if (workingDirPath.length() > 0) {
            new Path(workingDirPath);
        }
    }

    @Override
    protected String getMessage(int type) {
        switch (type) {
            case 1: {
                return Messages.InputFileBlock_DIRECTORY_NOT_SPECIFIED;
            }
            case 2: {
                return Messages.InputFileBlock_DIRECTORY_DOES_NOT_EXIST;
            }
            case 3: {
                return Messages.InputFileBlock_GROUP_NAME;
            }
            case 4: {
                return Messages.InputFileBlock_DEFAULT_RADIO;
            }
            case 5: {
                return Messages.InputFileBlock_OTHER_RADIO;
            }
            case 6: {
                return Messages.InputFileBlock_DIALOG_MESSAGE;
            }
            case 7: {
                return Messages.InputFileBlock_WORKSPACE_DIALOG_MESSAGE;
            }
            case 8: {
                return Messages.InputFileBlock_VARIABLES_BUTTON;
            }
            case 9: {
                return Messages.InputFileBlock_FILE_SYSTEM_BUTTON;
            }
            case 10: {
                return Messages.InputFileBlock_WORKSPACE_BUTTON;
            }
            case 11: {
                return Messages.InputFileBlock_WORKSPACE_DIALOG_TITLE;
            }
            case 12: {
                return Messages.InputFileBlock_OPENFILES_BUTTON;
            }
            case 13: {
                return Messages.InputFileBlock_OPENFILES_DIALOG;
            }
        }
        return "" + type;
    }

    @Override
    protected void updateResourceText(boolean useDefault) {
    }
}

