/*******************************************************************************
 * Copyright (c) 2005, 2011 Intel Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * Intel Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.internal.core.cdtvariables;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

/**
 * This is the default implementation of the IMacroContextInfo
 *
 * @since 3.0
 */
public class DefaultVariableContextInfo implements ICoreVariableContextInfo {

	private ICdtVariableSupplier fSuppliers[];
	private int fType;
	private Object fData;

	public DefaultVariableContextInfo(int type, Object data) {
		fType = type;
		fData = data;
	}

	protected DefaultVariableContextInfo(int type, Object data, ICdtVariableSupplier suppliers[]) {
		fType = type;
		fData = data;
		fSuppliers = suppliers;
	}

	protected ICdtVariableSupplier[] getSuppliers(int type, Object data) {
		switch (type) {
		case CONTEXT_CONFIGURATION:
			if (data instanceof ICConfigurationDescription) {
				return new ICdtVariableSupplier[] { CdtVariableManager.fUserDefinedMacroSupplier,
						CdtVariableManager.fBuildSystemVariableSupplier, CdtVariableManager.fEnvironmentMacroSupplier,
						CdtVariableManager.fCdtMacroSupplier };
			}
			break;
		case CONTEXT_WORKSPACE:
			if (data == null || data instanceof IWorkspace) {
				return new ICdtVariableSupplier[] { CdtVariableManager.fUserDefinedMacroSupplier,
						CdtVariableManager.fEnvironmentMacroSupplier, CdtVariableManager.fCdtMacroSupplier,
						CdtVariableManager.fEclipseVariablesMacroSupplier };
			}
			break;
		case CONTEXT_INSTALLATIONS:
			if (data == null) {
				return new ICdtVariableSupplier[] { CdtVariableManager.fCdtMacroSupplier };
			}
			break;
		case CONTEXT_ECLIPSEENV:
			if (data == null) {
				return new ICdtVariableSupplier[] { CdtVariableManager.fEnvironmentMacroSupplier };
			}
			break;
		}
		return null;
	}

	@Override
	public int getContextType() {
		return fType;
	}

	@Override
	public Object getContextData() {
		return fData;
	}

	@Override
	public ICdtVariableSupplier[] getSuppliers() {
		if (fSuppliers == null)
			fSuppliers = getSuppliers(fType, fData);
		return fSuppliers;
	}

	@Override
	public IVariableContextInfo getNext() {
		switch (fType) {
		case CONTEXT_CONFIGURATION:
			if (fData instanceof ICConfigurationDescription) {
				IWorkspace wsp = ResourcesPlugin.getWorkspace();
				if (wsp != null)
					return new DefaultVariableContextInfo(CONTEXT_WORKSPACE, wsp);
			}
			break;
		case CONTEXT_WORKSPACE:
			if (fData instanceof IWorkspace) {
				return new DefaultVariableContextInfo(CONTEXT_INSTALLATIONS, null);
			}
			break;
		case CONTEXT_INSTALLATIONS:
			if (fData == null) {
				return new DefaultVariableContextInfo(CONTEXT_ECLIPSEENV, null);
			}
			break;
		case CONTEXT_ECLIPSEENV:
			if (fData == null) {
				return null;
			}
			break;
		}
		return null;
	}
}
