/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContextListener;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.AbstractIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.IIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public class DisjointUnionTable
extends AbstractIndexTable {
    protected List<IIndexTable> childTables = CollectionsFactory.createObserverList();

    public DisjointUnionTable(IInputKey inputKey, ITableContext tableContext) {
        super(inputKey, tableContext);
    }

    public List<IIndexTable> getChildTables() {
        return Collections.unmodifiableList(this.childTables);
    }

    public void addChildTable(IIndexTable child) {
        if (this.getInputKey().getArity() != child.getInputKey().getArity()) {
            throw new IllegalArgumentException(child.toString());
        }
        this.childTables.add(child);
        if (this.emitNotifications) {
            for (Tuple tuple : child.enumerateTuples(this.emptyMask, Tuples.staticArityFlatTupleOf())) {
                this.deliverChangeNotifications(tuple, true);
            }
        }
    }

    @Override
    public int countTuples(TupleMask seedMask, ITuple seed) {
        int count2 = 0;
        for (IIndexTable child : this.childTables) {
            count2 += child.countTuples(seedMask, seed);
        }
        return count2;
    }

    @Override
    public Optional<Long> estimateProjectionSize(TupleMask groupMask, Accuracy requiredAccuracy) {
        if (groupMask.getSize() == 0) {
            for (IIndexTable child : this.childTables) {
                if (child.countTuples(this.emptyMask, Tuples.staticArityFlatTupleOf()) == 0) continue;
                return Optional.of(1L);
            }
            return Optional.of(0L);
        }
        if (groupMask.getSize() == this.emptyTuple.getSize()) {
            return Optional.of(Long.valueOf(this.countTuples(this.emptyMask, Tuples.staticArityFlatTupleOf())));
        }
        if (Accuracy.BEST_UPPER_BOUND.atLeastAsPreciseAs(requiredAccuracy)) {
            return Optional.of(Long.valueOf(this.countTuples(this.emptyMask, Tuples.staticArityFlatTupleOf())));
        }
        Optional<Long> maxProjection = Optional.empty();
        for (IIndexTable child : this.childTables) {
            Optional<Long> estimateOfChild = child.estimateProjectionSize(groupMask, requiredAccuracy);
            if (!estimateOfChild.isPresent()) continue;
            maxProjection = Optional.of(Math.max(estimateOfChild.get(), maxProjection.orElse(0L)));
        }
        return maxProjection;
    }

    @Override
    public Stream<? extends Tuple> streamTuples(TupleMask seedMask, ITuple seed) {
        Stream<Object> stream = Stream.empty();
        for (IIndexTable child : this.childTables) {
            Stream<? extends Tuple> childStream = child.streamTuples(seedMask, seed);
            stream = Stream.concat(stream, childStream);
        }
        return stream;
    }

    @Override
    public Stream<? extends Object> streamValues(TupleMask seedMask, ITuple seed) {
        Stream<Object> stream = Stream.empty();
        for (IIndexTable child : this.childTables) {
            Stream<? extends Object> childStream = child.streamValues(seedMask, seed);
            stream = Stream.concat(stream, childStream);
        }
        return stream;
    }

    @Override
    public boolean containsTuple(ITuple seed) {
        for (IIndexTable child : this.childTables) {
            if (!child.containsTuple(seed)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addUpdateListener(Tuple seed, IQueryRuntimeContextListener listener) {
        super.addUpdateListener(seed, listener);
        for (IIndexTable table : this.childTables) {
            table.addUpdateListener(seed, new ListenerWrapper(listener));
        }
    }

    @Override
    public void removeUpdateListener(Tuple seed, IQueryRuntimeContextListener listener) {
        super.removeUpdateListener(seed, listener);
        for (IIndexTable table : this.childTables) {
            table.removeUpdateListener(seed, new ListenerWrapper(listener));
        }
    }

    private class ListenerWrapper
    implements IQueryRuntimeContextListener {
        private IQueryRuntimeContextListener wrappedListener;

        public ListenerWrapper(IQueryRuntimeContextListener wrappedListener) {
            this.wrappedListener = wrappedListener;
        }

        @Override
        public void update(IInputKey key, Tuple updateTuple, boolean isInsertion) {
            this.wrappedListener.update(DisjointUnionTable.this.getInputKey(), updateTuple, isInsertion);
        }

        public int hashCode() {
            return Objects.hash(this.wrappedListener, DisjointUnionTable.this);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerWrapper other = (ListenerWrapper)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return Objects.equals(this.wrappedListener, other.wrappedListener);
        }

        private DisjointUnionTable getOuterType() {
            return DisjointUnionTable.this;
        }

        public String toString() {
            return "Wrapper to DisjointUnion(" + DisjointUnionTable.this.getInputKey().getPrettyPrintableName() + ") for " + this.wrappedListener;
        }
    }
}

