/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.base.relations;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sirius.ext.base.Messages;
import org.eclipse.sirius.ext.base.relations.Relation;

public class DependencyTracker<T> {
    private final Relation<T> relation;
    private final Set<T> trackedElements = new HashSet<T>();
    private final Multimap<T, T> dependencies = HashMultimap.create();
    private final Multimap<T, T> reverseDependencies = HashMultimap.create();

    public DependencyTracker(Relation<T> relation) {
        this.relation = (Relation)Preconditions.checkNotNull(relation);
    }

    public Set<T> getTrackedElements() {
        return ImmutableSet.copyOf(this.trackedElements);
    }

    public Set<T> getDependencies(T element) {
        Preconditions.checkNotNull(element);
        Preconditions.checkArgument((boolean)this.trackedElements.contains(element), (Object)MessageFormat.format(Messages.DependencyTracker_error_untrackedElement, element));
        return ImmutableSet.copyOf((Collection)this.dependencies.get(element));
    }

    public Set<T> getReverseDependencies(T element) {
        Preconditions.checkNotNull(element);
        return ImmutableSet.copyOf((Collection)this.reverseDependencies.get(element));
    }

    public synchronized void add(T element) {
        Preconditions.checkNotNull(element);
        if (this.dependencies.containsKey(element)) {
            this.update(element);
        } else {
            this.dependencies.putAll(element, this.relation.apply(element));
            for (Object dependency : this.dependencies.get(element)) {
                this.reverseDependencies.put(dependency, element);
            }
            this.trackedElements.add(element);
        }
    }

    public synchronized void remove(T element) {
        if (!this.dependencies.containsKey(element)) {
            return;
        }
        for (Object dependency : this.dependencies.get(element)) {
            this.reverseDependencies.remove(dependency, element);
        }
        this.dependencies.removeAll(element);
        this.trackedElements.remove(element);
    }

    public synchronized void update(T element) {
        Preconditions.checkNotNull(element);
        this.remove(element);
        this.add(element);
    }
}

