/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.MergeStrategyDescriptor;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.util.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public class MergeStrategies {
    public static final String EXTENSION_POINT = "org.eclipse.egit.core.mergeStrategy";
    private static volatile Loader loader;

    private MergeStrategies() {
    }

    public static MergeStrategy getPreferredMergeStrategy() {
        String key = Platform.getPreferencesService().getString("org.eclipse.egit.core", "core_preferredMergeStrategy", null, null);
        if (!StringUtils.isEmptyOrNull((String)key) && !"jgit-default-mergeStrategy".equals(key)) {
            Loader loadJob = loader;
            boolean jobDone = loadJob != null && loadJob.isDone();
            MergeStrategy result = MergeStrategy.get((String)key);
            if (result != null) {
                return result;
            }
            if (jobDone) {
                Activator.logError(MessageFormat.format(CoreText.Activator_invalidPreferredMergeStrategy, key), null);
            }
        }
        return null;
    }

    @NonNull
    public static Collection<MergeStrategyDescriptor> getRegisteredMergeStrategies() {
        Loader loadJob = loader;
        if (loadJob != null && loadJob.isDone()) {
            return loadJob.getRegisteredMergeStrategies();
        }
        return Collections.emptyList();
    }

    @Component
    public static class Loader
    extends Job {
        private IExtensionRegistry registry;
        private volatile MergeStrategyRegistryListener mergeStrategyRegistryListener;
        private volatile boolean done;

        public Loader() {
            super(CoreText.MergeStrategy_LoaderJob);
            this.setSystem(true);
            this.setUser(false);
        }

        @Reference
        void setExtensionRegistry(IExtensionRegistry registry) {
            this.registry = registry;
        }

        @Reference
        void setWorkspace(IWorkspace workspace) {
        }

        boolean isDone() {
            return this.done;
        }

        Collection<MergeStrategyDescriptor> getRegisteredMergeStrategies() {
            MergeStrategyRegistryListener listener = this.mergeStrategyRegistryListener;
            if (listener != null) {
                return listener.getCurrentStrategies();
            }
            return Collections.emptyList();
        }

        @Activate
        void start() {
            this.schedule();
            MergeStrategies.loader = this;
        }

        @Deactivate
        void shutDown() {
            MergeStrategies.loader = null;
            this.cancel();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.mergeStrategyRegistryListener != null) {
                this.registry.removeListener((IRegistryEventListener)this.mergeStrategyRegistryListener);
                this.mergeStrategyRegistryListener = null;
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                MergeStrategyRegistryListener listener = new MergeStrategyRegistryListener(this.registry);
                if (!monitor.isCanceled()) {
                    this.registry.addListener((IRegistryEventListener)listener, MergeStrategies.EXTENSION_POINT);
                    this.mergeStrategyRegistryListener = listener;
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
            }
            finally {
                this.done = true;
                monitor.done();
            }
            return Status.CANCEL_STATUS;
        }
    }

    private static class MergeStrategyRegistryListener
    implements IRegistryEventListener {
        private Map<String, MergeStrategyDescriptor> strategies = new LinkedHashMap<String, MergeStrategyDescriptor>();
        private volatile Collection<MergeStrategyDescriptor> currentStrategies = Collections.emptyList();

        private MergeStrategyRegistryListener(IExtensionRegistry registry) {
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(MergeStrategies.EXTENSION_POINT);
            if (this.loadMergeStrategies(elements)) {
                this.currentStrategies = this.getStrategies();
            }
        }

        private Collection<MergeStrategyDescriptor> getStrategies() {
            return new ArrayList<MergeStrategyDescriptor>(this.strategies.values());
        }

        @NonNull
        public Collection<MergeStrategyDescriptor> getCurrentStrategies() {
            return Collections.unmodifiableCollection(this.currentStrategies);
        }

        public void added(IExtension[] extensions) {
            boolean changed = false;
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                changed |= this.loadMergeStrategies(extension.getConfigurationElements());
                ++n2;
            }
            if (changed) {
                this.currentStrategies = this.getStrategies();
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            boolean changed = false;
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        Object ext = element.createExecutableExtension("class");
                        if (ext instanceof MergeStrategy) {
                            MergeStrategy strategy = (MergeStrategy)ext;
                            changed |= this.strategies.remove(strategy.getName()) != null;
                        }
                    }
                    catch (CoreException e) {
                        Activator.logError(CoreText.MergeStrategy_UnloadError, e);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (changed) {
                this.currentStrategies = this.getStrategies();
            }
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }

        private boolean loadMergeStrategies(IConfigurationElement[] elements) {
            boolean changed = false;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    Object ext = element.createExecutableExtension("class");
                    if (ext instanceof MergeStrategy) {
                        MergeStrategy strategy = (MergeStrategy)ext;
                        String name = element.getAttribute("name");
                        if (name == null || name.isEmpty()) {
                            name = strategy.getName();
                        }
                        if (this.canRegister(name, strategy)) {
                            if (MergeStrategy.get((String)name) == null) {
                                MergeStrategy.register((String)name, (MergeStrategy)strategy);
                            }
                            this.strategies.put(name, new MergeStrategyDescriptor(name, element.getAttribute("label"), strategy.getClass()));
                            changed = true;
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.logError(CoreText.MergeStrategy_LoadError, e);
                }
                ++n2;
            }
            return changed;
        }

        private boolean canRegister(String name, MergeStrategy strategy) {
            boolean result = true;
            if (name == null || name.isEmpty()) {
                Activator.logError(MessageFormat.format(CoreText.MergeStrategy_MissingName, strategy.getClass()), null);
                result = false;
            } else if (this.strategies.containsKey(name)) {
                Activator.logError(MessageFormat.format(CoreText.MergeStrategy_DuplicateName, name, this.strategies.get(name).getImplementedBy(), strategy.getClass()), null);
                result = false;
            } else if (MergeStrategy.get((String)name) != null && MergeStrategy.get((String)name) != strategy) {
                Activator.logError(MessageFormat.format(CoreText.MergeStrategy_ReservedName, name, MergeStrategy.get((String)name).getClass(), strategy.getClass()), null);
                result = false;
            }
            return result;
        }
    }
}

