/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.debug;

import org.eclipse.dltk.launching.InterpreterConfig;

public class DbgpConnectionConfig {
    private final String host;
    private final int port;
    private final String sessionId;

    private DbgpConnectionConfig(String host, int port, String sessionId) {
        this.host = host;
        this.port = port;
        this.sessionId = sessionId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public static DbgpConnectionConfig load(InterpreterConfig config) {
        String host = (String)config.getProperty("host");
        String port = (String)config.getProperty("port");
        String sessionId = (String)config.getProperty("sessionId");
        return new DbgpConnectionConfig(host, Integer.parseInt(port), sessionId);
    }

    public static void save(InterpreterConfig config, String host, int port, String sessionId) {
        config.setProperty("host", host);
        config.setProperty("port", Integer.toString(port));
        config.setProperty("sessionId", sessionId);
    }
}

