/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.uriresolver.internal.util.URIEncoder;

public class UniversalPathTransformer {
    public static final String PLATFORM_PREFIX = "platform:/resource/";
    public static final String LOCATION_PREFIX = "file:/";
    private static String PROTOCOL_MARKER = ":";
    private static char PATH_SEPARATOR = (char)47;

    private static boolean isPrefix(String uri, String prefix) {
        if (prefix.length() >= uri.length()) {
            return false;
        }
        return uri.substring(0, prefix.length()).equalsIgnoreCase(prefix);
    }

    public static String toPath(String str) {
        IFile file;
        if (str == null || str.length() == 0) {
            return str;
        }
        if (UniversalPathTransformer.isPrefix(str, PLATFORM_PREFIX)) {
            str = str.substring(PLATFORM_PREFIX.length() - 1);
        } else if (UniversalPathTransformer.isPrefix(str, LOCATION_PREFIX) && (file = UniversalPathTransformer.toFile(str)) != null) {
            str = file.getFullPath().makeAbsolute().toString();
        }
        return str;
    }

    public static String toPlatformPath(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (UniversalPathTransformer.isPrefix(str, LOCATION_PREFIX)) {
            IFile file = UniversalPathTransformer.toFile(str);
            if (file != null) {
                str = PLATFORM_PREFIX + file.getFullPath().makeRelative();
            }
        } else if (str.indexOf(PROTOCOL_MARKER) == -1) {
            str = str.charAt(0) == PATH_SEPARATOR ? PLATFORM_PREFIX + str.substring(1) : PLATFORM_PREFIX + str;
        }
        return str;
    }

    public static String toLocation(String str) {
        IFile file;
        if (str == null || str.length() == 0) {
            return str;
        }
        String s = str;
        if (UniversalPathTransformer.isPrefix(s, PLATFORM_PREFIX)) {
            s = UniversalPathTransformer.toPath(s);
        }
        if (s.indexOf(PROTOCOL_MARKER) == -1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(s))) != null) {
            str = file.getLocationURI().toString();
        }
        return str;
    }

    public static IFile toFile(String str) {
        IFile file = null;
        if (UniversalPathTransformer.isPrefix(str, LOCATION_PREFIX)) {
            str = str.substring(LOCATION_PREFIX.length()).replaceAll("%20", " ");
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(str));
        } else {
            if (str.startsWith(PLATFORM_PREFIX)) {
                str = str.substring(PLATFORM_PREFIX.length());
            }
            if (str.indexOf(PROTOCOL_MARKER) == -1) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(str));
            }
        }
        return file;
    }

    public static IFile[] toFiles(String[] uris) {
        IFile[] files = null;
        if (uris != null) {
            files = new IFile[uris.length];
            int i = 0;
            while (i < uris.length) {
                String uri = uris[i];
                files[i] = UniversalPathTransformer.toFile(uri);
                ++i;
            }
        }
        return files;
    }

    public static String uriToLocation(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        String s = str;
        if (UniversalPathTransformer.isPrefix(s, PLATFORM_PREFIX)) {
            s = UniversalPathTransformer.toPath(s);
        }
        if (s.indexOf(PROTOCOL_MARKER) == -1) {
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(URLDecoder.decode(s, "UTF-8")));
                if (file != null) {
                    str = UniversalPathTransformer.uriCreate(URLDecoder.decode(file.getLocationURI().toString(), "UTF-8")).toString();
                }
            }
            catch (Exception exception) {}
        }
        return str;
    }

    private static URI uriCreate(String uri) {
        if (uri != null) {
            uri = uri.replace('\\', '/');
        }
        try {
            try {
                return URI.create(uri);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return URI.create(URIEncoder.encode((String)uri, (String)"UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URI.create("");
        }
    }
}

