/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.indexer;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.network.indexer.DefaultMessageIndexer;
import org.eclipse.viatra.query.runtime.rete.network.indexer.MessageIndexer;

public class GroupBasedMessageIndexer
implements MessageIndexer {
    protected final Map<Tuple, DefaultMessageIndexer> indexer = CollectionsFactory.createMap();
    protected final TupleMask groupMask;

    public GroupBasedMessageIndexer(TupleMask groupMask) {
        this.groupMask = groupMask;
    }

    public Map<Tuple, Integer> getTuplesByGroup(Tuple group) {
        DefaultMessageIndexer values = this.indexer.get(group);
        if (values == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(values.getTuples());
    }

    @Override
    public int getCount(Tuple update) {
        Tuple group = this.groupMask.transform((ITuple)update);
        Integer count = this.getTuplesByGroup(group).get(update);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public Set<Tuple> getGroups() {
        return Collections.unmodifiableSet(this.indexer.keySet());
    }

    @Override
    public void insert(Tuple update) {
        this.update(update, 1);
    }

    @Override
    public void delete(Tuple update) {
        this.update(update, -1);
    }

    @Override
    public void update(Tuple update, int delta) {
        Tuple group = this.groupMask.transform((ITuple)update);
        DefaultMessageIndexer valueIndexer = this.indexer.get(group);
        if (valueIndexer == null) {
            valueIndexer = new DefaultMessageIndexer();
            this.indexer.put(group, valueIndexer);
        }
        valueIndexer.update(update, delta);
        if (valueIndexer.isEmpty()) {
            this.indexer.remove(group);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.indexer.isEmpty();
    }

    public void clear() {
        this.indexer.clear();
    }
}

