/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmSimpleState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenRuntimeData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenRuntimeFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenario;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenFsm
extends DataDrivenFsmState {
    private final DataDrivenFsmState fInitial;
    private final Map<String, DataDrivenFsmSimpleState> fStates;
    private final DataDrivenCondition fPrecondition;
    private final boolean fConsuming;
    private final boolean fMultipleInstances;

    public DataDrivenFsm(String id, DataDrivenFsmState initial, Map<String, DataDrivenFsmSimpleState> states, DataDrivenCondition preCondition, boolean consuming, boolean multipleInstances) {
        super(id);
        this.fInitial = initial;
        this.fStates = states;
        this.fPrecondition = preCondition;
        this.fConsuming = consuming;
        this.fMultipleInstances = multipleInstances;
    }

    public void createScenario(ITmfEvent event, boolean force, DataDrivenRuntimeData executionData, IAnalysisDataContainer container) {
        DataDrivenRuntimeFsm runtimeFsm = executionData.getRuntimeForFsm(this);
        if (force || this.isNewScenarioAllowed(runtimeFsm)) {
            runtimeFsm.addPendingScenario(new DataDrivenScenario(event, this, this.fInitial, container, executionData));
        }
    }

    public synchronized boolean isNewScenarioAllowed(DataDrivenRuntimeFsm runtimeFsm) {
        return runtimeFsm.getScenarioCount() > 0 && this.fMultipleInstances && runtimeFsm.getPendingScenario() == null;
    }

    public void handleEvent(ITmfEvent event, DataDrivenRuntimeData executionData, IAnalysisDataContainer container) {
        if (!this.fPrecondition.test(event, DataDrivenScenarioInfo.DUMMY_SCENARIO, container)) {
            return;
        }
        DataDrivenRuntimeFsm runtimeFsm = executionData.getRuntimeForFsm(this);
        boolean eventConsumed = false;
        eventConsumed = this.handleActiveScenarios(event, runtimeFsm, container);
        this.handlePendingScenario(event, eventConsumed, runtimeFsm, container);
    }

    private void handlePendingScenario(ITmfEvent event, boolean eventConsumed, DataDrivenRuntimeFsm runtimeFsm, IAnalysisDataContainer container) {
        if (this.fConsuming && eventConsumed) {
            return;
        }
        DataDrivenScenario scenario = runtimeFsm.getPendingScenario();
        if (scenario != null) {
            scenario.handleEvent(event, container);
            if (!scenario.isPending()) {
                runtimeFsm.activatePending();
            }
        }
    }

    private boolean handleActiveScenarios(ITmfEvent event, DataDrivenRuntimeFsm runtimeFsm, IAnalysisDataContainer container) {
        boolean eventConsumed = false;
        ArrayList<DataDrivenScenario> toRemove = new ArrayList<DataDrivenScenario>();
        for (DataDrivenScenario scenario : runtimeFsm.getActiveScenarios()) {
            if (!scenario.isActive()) {
                toRemove.add(scenario);
                continue;
            }
            if ((scenario.isActive() || scenario.isPending()) && this.fConsuming && (eventConsumed |= scenario.handleEvent(event, container))) break;
        }
        for (DataDrivenScenario scenario : toRemove) {
            runtimeFsm.removeScenario(scenario);
        }
        return eventConsumed;
    }

    public void dispose(DataDrivenRuntimeData executionData) {
        for (DataDrivenScenario scenario : executionData.getRuntimeForFsm(this).getActiveScenarios()) {
            if (!scenario.isActive()) continue;
            scenario.cancel();
        }
    }

    public DataDrivenFsmSimpleState getState(String stateName) {
        return Objects.requireNonNull(this.fStates.get(stateName), "The requested state should exist");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fInitial, this.fStates, this.fPrecondition, this.fConsuming, this.fMultipleInstances);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DataDrivenFsm)) {
            return false;
        }
        DataDrivenFsm other = (DataDrivenFsm)obj;
        return super.equals(obj) && Objects.equals(this.fInitial, other.fInitial) && Objects.equals(this.fPrecondition, other.fPrecondition) && Objects.equals(this.fConsuming, other.fConsuming) && Objects.equals(this.fMultipleInstances, other.fMultipleInstances) && Objects.equals(this.fStates, other.fStates);
    }

    public String toString() {
        return "FSM " + this.getId() + ':' + this.fInitial + ' ' + this.fPrecondition + ' ' + this.fConsuming + ' ' + this.fMultipleInstances + ' ' + this.fStates;
    }
}

