/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractActionDelegate
extends EventManager
implements IViewActionDelegate,
IActionDelegate2,
IWorkbenchWindowActionDelegate,
IObjectActionDelegate,
IHandler2 {
    private IAction action;
    private IWorkbenchPart part;
    private IWorkbenchWindow window;
    private ExecutionEvent event;
    private ISelection selection;
    private ISelection event_selection;
    private Object context;
    private boolean enabled;

    public void init(IAction action) {
        this.action = action;
    }

    public void init(IViewPart view) {
        this.part = view;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dispose() {
        this.action = null;
        this.part = null;
        this.window = null;
    }

    public void addHandlerListener(IHandlerListener listener) {
        this.addListenerObject(listener);
    }

    public void removeHandlerListener(IHandlerListener listener) {
        this.removeListenerObject(listener);
    }

    protected void fireHandlerChanged(HandlerEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IHandlerListener listener = (IHandlerListener)listeners[i];
            listener.handlerChanged(event);
            ++i;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.action = action;
        this.part = part;
        this.window = part.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        IAction action0 = this.action;
        try {
            this.action = action;
            this.run();
        }
        finally {
            this.action = action0;
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        IAction action0 = this.action;
        try {
            this.action = action;
            this.selectionChanged();
        }
        finally {
            this.action = action0;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.action != null) {
            this.action.setEnabled(enabled);
        }
    }

    public void setEnabled(Object context) {
        this.context = context;
    }

    public boolean isEnabled() {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.window == null) {
            return false;
        }
        this.part = this.window.getActivePage().getActivePart();
        if (this.part == null) {
            return false;
        }
        ISelectionProvider selection_provider = this.part.getSite().getSelectionProvider();
        if (selection_provider == null) {
            return false;
        }
        this.selection = selection_provider.getSelection();
        if (this.selection == null) {
            return false;
        }
        this.selectionChanged();
        return this.enabled;
    }

    public IWorkbenchPart getPart() {
        if (this.event != null) {
            return HandlerUtil.getActivePart((ExecutionEvent)this.event);
        }
        return this.part;
    }

    public IWorkbenchWindow getWindow() {
        if (this.event != null && HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)this.event) != null) {
            return HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)this.event);
        }
        if (this.part != null) {
            return this.part.getSite().getWorkbenchWindow();
        }
        if (this.window != null) {
            return this.window;
        }
        if (PlatformUI.getWorkbench() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return null;
    }

    public ISelection getSelection() {
        if (this.event != null) {
            return this.event_selection;
        }
        return this.selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            try {
                this.event = event;
                this.event_selection = this.selection;
                this.run();
            }
            catch (Throwable x) {
                throw new ExecutionException("Command aborted", x);
            }
        }
        finally {
            this.event = null;
            this.event_selection = null;
        }
        return null;
    }

    public boolean isHandled() {
        return true;
    }

    public TCFNode getSelectedNode() {
        ISelection s = this.getSelection();
        if (s instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)s).getFirstElement();
            if (o instanceof TCFNode) {
                return (TCFNode)o;
            }
            if (o instanceof TCFLaunch) {
                return TCFModelManager.getRootNodeSync((Launch)((TCFLaunch)o));
            }
        }
        return null;
    }

    public TCFNode[] getSelectedNodes() {
        IStructuredSelection s;
        ISelection s0 = this.getSelection();
        ArrayList<TCFNode> list = new ArrayList<TCFNode>();
        if (s0 instanceof IStructuredSelection && (s = (IStructuredSelection)s0).size() > 0) {
            Object[] objectArray = s.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                TCFNodeLaunch n3;
                Object o = objectArray[n2];
                if (o instanceof TCFNode) {
                    list.add((TCFNode)o);
                } else if (o instanceof TCFLaunch && (n3 = TCFModelManager.getRootNodeSync((Launch)((TCFLaunch)o))) != null) {
                    list.add(n3);
                }
                ++n2;
            }
        }
        return list.toArray(new TCFNode[list.size()]);
    }

    protected abstract void selectionChanged();

    protected abstract void run();
}

