/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.piecharts;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.events.CircularMouseDownEvent;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.MouseDownEvent;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesData;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;

public class PieChart
extends ScrollableChart {
    public PieChart() {
    }

    public PieChart(Composite parent, int style) {
        super(parent, style);
    }

    public void addSeriesData(ICircularSeriesData model) {
        if (model != null && model.getRootNode() != null) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            try {
                ICircularSeriesSettings pieSeriesSettings = model.getSettings();
                IChartSettings chartSettings = this.getChartSettings();
                chartSettings.setHorizontalSliderVisible(false);
                chartSettings.setVerticalSliderVisible(false);
                chartSettings.getRangeRestriction().setZeroX(false);
                chartSettings.getRangeRestriction().setZeroY(false);
                chartSettings.setLegendVisible(true);
                IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
                primaryAxisSettingsX.setTitle(model.getNodeClass());
                primaryAxisSettingsX.setVisible(false);
                IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
                primaryAxisSettingsY.setTitle(model.getValueClass());
                primaryAxisSettingsY.setVisible(false);
                chartSettings.setShowLegendMarker(true);
                chartSettings.setColorLegendMarker(Display.getDefault().getSystemColor(2));
                IHandledEventProcessor handledEventProcessor = null;
                for (IHandledEventProcessor processor : chartSettings.getHandledEventProcessors()) {
                    if (!(processor instanceof MouseDownEvent)) continue;
                    handledEventProcessor = processor;
                    break;
                }
                if (handledEventProcessor != null) {
                    chartSettings.removeHandledEventProcessor(handledEventProcessor);
                }
                CircularMouseDownEvent circularHandledEventProcessor = new CircularMouseDownEvent(this);
                chartSettings.addHandledEventProcessor(circularHandledEventProcessor);
                this.applySettings(chartSettings);
                ICircularSeries<?> pieSeries = this.createCircularSeries(model, pieSeriesSettings);
                baseChart.applyCircularSeriesSettings(pieSeries, pieSeriesSettings);
            }
            catch (SeriesException seriesException) {
                // empty catch block
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }
}

