/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.requirement;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.reddeer.junit.annotation.AnnotationUtils;
import org.eclipse.reddeer.junit.requirement.ConfigurableRequirement;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.requirement.RequirementException;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfigurationPool;
import org.eclipse.reddeer.junit.requirement.matcher.RequirementMatcher;
import org.hamcrest.Matcher;

public class RequirementHelper {
    public static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RequirementException("Error during instantiation of a requirement", e);
        }
        catch (IllegalAccessException e) {
            throw new RequirementException("Error during instantiation of a requirement", e);
        }
        catch (NullPointerException e) {
            throw new RequirementException("Error during instantiation of a null requirement object", e);
        }
    }

    public static List<Requirement<?>> getRequirements(Class<?> clazz) {
        ArrayList requirements = new ArrayList();
        for (Annotation annotation : AnnotationUtils.getRequirementAnnotations(clazz)) {
            Class<Requirement<Annotation>> requirementClass = AnnotationUtils.getEnclosingRequirementClass(annotation.annotationType());
            if (requirementClass == null) continue;
            Requirement<Annotation> requirement = RequirementHelper.createInstance(requirementClass);
            requirement.setDeclaration(annotation);
            requirements.add(requirement);
        }
        return requirements;
    }

    public static List<RequirementConfiguration> getRequirementConfigurations(ConfigurableRequirement requirement, Collection<RequirementMatcher> matchers) {
        ArrayList<RequirementConfiguration> result = new ArrayList<RequirementConfiguration>();
        List<RequirementConfiguration> configurations = RequirementConfigurationPool.getInstance().getConfigurations(requirement.getConfigurationClass());
        if (matchers == null) {
            result.addAll(configurations);
        } else {
            for (RequirementConfiguration configuration : configurations) {
                AtomicBoolean matcherIsDefined = new AtomicBoolean(false);
                matchers.stream().collect(Collectors.groupingBy(RequirementMatcher::getConfigurationClass)).forEach((config, listOfMatchers) -> {
                    if (config.equals(requirement.getDeclaration().annotationType()) && configuration.getClass().equals(requirement.getConfigurationClass())) {
                        matcherIsDefined.set(true);
                        AtomicBoolean matchersPassed = new AtomicBoolean(true);
                        listOfMatchers.forEach(matcher -> {
                            if (!matcher.matches(configuration)) {
                                matchersPassed.set(false);
                            }
                        });
                        if (matchersPassed.get()) {
                            result.add(configuration);
                        }
                    }
                });
                if (matcherIsDefined.get()) continue;
                result.add(configuration);
            }
        }
        return result;
    }

    public static List<ConfigurableRequirement> buildCustomRequirements(ConfigurableRequirement customRequirement, Matcher configurationMatcher) {
        ArrayList<ConfigurableRequirement> result = new ArrayList<ConfigurableRequirement>();
        List<RequirementConfiguration> configurations = RequirementConfigurationPool.getInstance().getConfigurations(customRequirement.getConfigurationClass());
        Object declaration = customRequirement.getDeclaration();
        for (RequirementConfiguration configuration : configurations) {
            if (configurationMatcher != null && (configurationMatcher == null || !configurationMatcher.matches((Object)configuration))) continue;
            ConfigurableRequirement requirement = (ConfigurableRequirement)RequirementHelper.createInstance(customRequirement.getClass());
            requirement.setDeclaration(declaration);
            requirement.setConfiguration(configuration);
            result.add(requirement);
        }
        return result;
    }
}

