/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.internal.util.om.InternalOMJob;
import org.eclipse.net4j.internal.util.om.LegacyBundle;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.om.LegacyUtil;
import org.eclipse.net4j.util.om.OMBundle;

public class LegacyPlatform
extends AbstractPlatform {
    private final Map<String, String> debugOptions = new ConcurrentHashMap<String, String>(0);
    private final Map<InternalOMJob, IProgressMonitor> jobMonitors = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean isOSGiRunning() {
        return false;
    }

    @Override
    protected OMBundle createBundle(String bundleID, Class<?> accessor) {
        return new LegacyBundle(this, bundleID, accessor);
    }

    @Override
    protected String getDebugOption(String bundleID, String option) {
        return this.debugOptions.get(String.valueOf(bundleID) + "/" + option);
    }

    @Override
    protected void setDebugOption(String bundleID, String option, String value) {
        this.debugOptions.put(String.valueOf(bundleID) + "/" + option, value);
    }

    @Override
    public String[] getCommandLineArgs() {
        return LegacyUtil.getCommandLineArgs();
    }

    @Override
    public void scheduleJob(InternalOMJob job) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.jobMonitors.put(job, (IProgressMonitor)monitor);
        ExecutorService threadPool = ConcurrencyUtil.getExecutorService(IPluginContainer.INSTANCE);
        threadPool.submit(() -> this.lambda$0(job, (IProgressMonitor)monitor));
    }

    @Override
    public void cancelJob(InternalOMJob job) {
        IProgressMonitor monitor = this.jobMonitors.get(job);
        if (monitor != null) {
            monitor.setCanceled(true);
        }
    }

    @Override
    public void renameJob(InternalOMJob job, String name) {
    }

    public static boolean clearDebugOptions() {
        if (INSTANCE instanceof LegacyPlatform) {
            LegacyPlatform platform = (LegacyPlatform)INSTANCE;
            platform.debugOptions.clear();
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$0(InternalOMJob internalOMJob, IProgressMonitor iProgressMonitor) {
        try {
            internalOMJob.run(iProgressMonitor);
        }
        finally {
            this.jobMonitors.remove(internalOMJob);
        }
    }
}

