/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.maven.index.AbstractSearchPageableRequest;
import org.apache.maven.index.AbstractSearchRequest;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoGroup;
import org.apache.maven.index.DefaultIteratorResultSet;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Grouping;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.NexusIndexMultiReader;
import org.apache.maven.index.context.NexusIndexMultiSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultSearchEngine
implements SearchEngine {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    @Deprecated
    public Set<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> artifactInfoComparator, IndexingContext indexingContext, Query query) throws IOException {
        return this.searchFlatPaged(new FlatSearchRequest(query, artifactInfoComparator, indexingContext), Arrays.asList(indexingContext), true).getResults();
    }

    @Override
    @Deprecated
    public Set<ArtifactInfo> searchFlat(Comparator<ArtifactInfo> artifactInfoComparator, Collection<IndexingContext> indexingContexts, Query query) throws IOException {
        return this.searchFlatPaged(new FlatSearchRequest(query, artifactInfoComparator), indexingContexts).getResults();
    }

    @Override
    public FlatSearchResponse searchFlatPaged(FlatSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchFlatPaged(request, indexingContexts, false);
    }

    @Override
    public FlatSearchResponse forceSearchFlatPaged(FlatSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchFlatPaged(request, indexingContexts, true);
    }

    protected FlatSearchResponse searchFlatPaged(FlatSearchRequest request, Collection<IndexingContext> indexingContexts, boolean ignoreContext) throws IOException {
        List<IndexingContext> contexts = this.getParticipatingContexts(indexingContexts, ignoreContext);
        TreeSet<ArtifactInfo> result = new TreeSet<ArtifactInfo>(request.getArtifactInfoComparator());
        return new FlatSearchResponse(request.getQuery(), this.searchFlat(request, result, contexts, request.getQuery()), result);
    }

    @Override
    public GroupedSearchResponse searchGrouped(GroupedSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchGrouped(request, indexingContexts, false);
    }

    @Override
    public GroupedSearchResponse forceSearchGrouped(GroupedSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchGrouped(request, indexingContexts, true);
    }

    protected GroupedSearchResponse searchGrouped(GroupedSearchRequest request, Collection<IndexingContext> indexingContexts, boolean ignoreContext) throws IOException {
        List<IndexingContext> contexts = this.getParticipatingContexts(indexingContexts, ignoreContext);
        TreeMap<String, ArtifactInfoGroup> result = new TreeMap<String, ArtifactInfoGroup>(request.getGroupKeyComparator());
        return new GroupedSearchResponse(request.getQuery(), this.searchGrouped(request, result, request.getGrouping(), contexts, request.getQuery()), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int searchFlat(FlatSearchRequest req, Collection<ArtifactInfo> result, List<IndexingContext> participatingContexts, Query query) throws IOException {
        int hitCount = 0;
        for (IndexingContext context : participatingContexts) {
            IndexSearcher indexSearcher = context.acquireIndexSearcher();
            try {
                int start;
                TopScoreDocCollector collector = this.doSearchWithCeiling(req, indexSearcher, query);
                if (collector.getTotalHits() == 0) continue;
                ScoreDoc[] scoreDocs = collector.topDocs().scoreDocs;
                hitCount += collector.getTotalHits();
                for (int i = start = 0; i < scoreDocs.length; ++i) {
                    Document doc = indexSearcher.doc(scoreDocs[i].doc);
                    ArtifactInfo artifactInfo = IndexUtils.constructArtifactInfo((Document)doc, (IndexingContext)context);
                    if (artifactInfo == null) continue;
                    artifactInfo.setRepository(context.getRepositoryId());
                    artifactInfo.setContext(context.getId());
                    if (req.getArtifactInfoFilter() != null && !req.getArtifactInfoFilter().accepts(context, artifactInfo)) continue;
                    if (req.getArtifactInfoPostprocessor() != null) {
                        req.getArtifactInfoPostprocessor().postprocess(context, artifactInfo);
                    }
                    result.add(artifactInfo);
                }
            }
            finally {
                context.releaseIndexSearcher(indexSearcher);
            }
        }
        return hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int searchGrouped(GroupedSearchRequest req, Map<String, ArtifactInfoGroup> result, Grouping grouping, List<IndexingContext> participatingContexts, Query query) throws IOException {
        int hitCount = 0;
        for (IndexingContext context : participatingContexts) {
            IndexSearcher indexSearcher = context.acquireIndexSearcher();
            try {
                TopScoreDocCollector collector = this.doSearchWithCeiling(req, indexSearcher, query);
                if (collector.getTotalHits() <= 0) continue;
                ScoreDoc[] scoreDocs = collector.topDocs().scoreDocs;
                hitCount += collector.getTotalHits();
                for (int i = 0; i < scoreDocs.length; ++i) {
                    Document doc = indexSearcher.doc(scoreDocs[i].doc);
                    ArtifactInfo artifactInfo = IndexUtils.constructArtifactInfo((Document)doc, (IndexingContext)context);
                    if (artifactInfo == null) continue;
                    artifactInfo.setRepository(context.getRepositoryId());
                    artifactInfo.setContext(context.getId());
                    if (req.getArtifactInfoFilter() != null && !req.getArtifactInfoFilter().accepts(context, artifactInfo)) continue;
                    if (req.getArtifactInfoPostprocessor() != null) {
                        req.getArtifactInfoPostprocessor().postprocess(context, artifactInfo);
                    }
                    if (grouping.addArtifactInfo(result, artifactInfo)) continue;
                    --hitCount;
                }
            }
            finally {
                context.releaseIndexSearcher(indexSearcher);
            }
        }
        return hitCount;
    }

    @Override
    public IteratorSearchResponse searchIteratorPaged(IteratorSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchIteratorPaged(request, indexingContexts, false);
    }

    @Override
    public IteratorSearchResponse forceSearchIteratorPaged(IteratorSearchRequest request, Collection<IndexingContext> indexingContexts) throws IOException {
        return this.searchIteratorPaged(request, indexingContexts, true);
    }

    private IteratorSearchResponse searchIteratorPaged(IteratorSearchRequest request, Collection<IndexingContext> indexingContexts, boolean ignoreContext) throws IOException {
        List<IndexingContext> contexts = this.getParticipatingContexts(indexingContexts, ignoreContext);
        NexusIndexMultiReader multiReader = this.getMergedIndexReader(indexingContexts, ignoreContext);
        NexusIndexMultiSearcher indexSearcher = new NexusIndexMultiSearcher(multiReader);
        try {
            TopScoreDocCollector hits = this.doSearchWithCeiling(request, (IndexSearcher)indexSearcher, request.getQuery());
            return new IteratorSearchResponse(request.getQuery(), hits.getTotalHits(), new DefaultIteratorResultSet(request, indexSearcher, contexts, hits.topDocs()));
        }
        catch (IOException e) {
            try {
                indexSearcher.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                indexSearcher.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    protected TopScoreDocCollector doSearchWithCeiling(AbstractSearchRequest request, IndexSearcher indexSearcher, Query query) throws IOException {
        int topHitCount = this.getTopDocsCollectorHitNum(request, -1);
        if (-1 != topHitCount) {
            TopScoreDocCollector hits = TopScoreDocCollector.create((int)topHitCount);
            indexSearcher.search(query, (Collector)hits);
            return hits;
        }
        topHitCount = 1000;
        TopScoreDocCollector hits = TopScoreDocCollector.create((int)topHitCount);
        indexSearcher.search(query, (Collector)hits);
        if (topHitCount < hits.getTotalHits()) {
            topHitCount = hits.getTotalHits();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing unbounded search, and fitting topHitCounts to " + topHitCount + ", an OOMEx might follow. To avoid OOM use narrower queries or limit your expectancy with request.setCount() method where appropriate. See MINDEXER-14 for details.");
            }
            hits = TopScoreDocCollector.create((int)topHitCount);
            indexSearcher.search(query, (Collector)hits);
        }
        return hits;
    }

    protected List<IndexingContext> getParticipatingContexts(Collection<IndexingContext> indexingContexts, boolean ignoreContext) {
        ArrayList<IndexingContext> contexts = new ArrayList<IndexingContext>(indexingContexts.size());
        for (IndexingContext ctx : indexingContexts) {
            if (!ignoreContext && !ctx.isSearchable()) continue;
            contexts.add(ctx);
        }
        return contexts;
    }

    protected NexusIndexMultiReader getMergedIndexReader(Collection<IndexingContext> indexingContexts, boolean ignoreContext) throws IOException {
        List<IndexingContext> contexts = this.getParticipatingContexts(indexingContexts, ignoreContext);
        return new NexusIndexMultiReader(contexts);
    }

    protected int getTopDocsCollectorHitNum(AbstractSearchRequest request, int ceiling) {
        if (request instanceof AbstractSearchPageableRequest) {
            AbstractSearchPageableRequest prequest = (AbstractSearchPageableRequest)request;
            if (-1 != prequest.getCount()) {
                return prequest.getCount() + prequest.getStart();
            }
        } else if (-1 != request.getCount()) {
            return request.getCount();
        }
        return ceiling;
    }
}

