/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.editing;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeCreator {
    private static final Logger log = LoggerFactory.getLogger(ChangeCreator.class);
    private String label;
    private IDocument oldDocument;
    private IDocument newDocument;
    private IFile oldFile;

    public ChangeCreator(IFile oldFile, IDocument oldDocument, IDocument newDocument, String label) {
        this.newDocument = newDocument;
        this.oldDocument = oldDocument;
        this.oldFile = oldFile;
        this.label = label;
    }

    public TextChange createChange() throws Exception {
        DocumentChange change = this.oldFile == null ? new DocumentChange(this.label, this.oldDocument) : new TextFileChange(this.label, this.oldFile);
        change.setEdit((TextEdit)new MultiTextEdit());
        LineComparator leftSide = new LineComparator(this.oldDocument);
        LineComparator rightSide = new LineComparator(this.newDocument);
        RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftSide, (IRangeComparator)rightSide);
        int i = 0;
        while (i < differences.length) {
            RangeDifference curr = differences[i];
            if (curr.leftLength() != 0 || curr.rightLength() != 0) {
                int rightOffset = this.newDocument.getLineOffset(curr.rightStart());
                int rightLength = curr.rightLength() == 0 ? 0 : this.newDocument.getLineOffset(curr.rightEnd() - 1) - rightOffset + this.newDocument.getLineLength(curr.rightEnd() - 1);
                int leftOffset = this.oldDocument.getLineOffset(curr.leftStart());
                int leftLength = curr.leftLength() == 0 ? 0 : this.oldDocument.getLineOffset(curr.leftEnd() - 1) - leftOffset + this.oldDocument.getLineLength(curr.leftEnd() - 1);
                String newText = this.newDocument.get(rightOffset, rightLength);
                this.addEdit((TextChange)change, curr.leftStart(), (TextEdit)new ReplaceEdit(leftOffset, leftLength, newText));
            }
            ++i;
        }
        return change;
    }

    private void addEdit(TextChange change, int startLine, TextEdit edit) {
        change.addTextEditGroup(new TextEditGroup("Line " + (startLine + 1), edit));
        change.addEdit(edit);
    }

    public static class LineComparator
    implements IRangeComparator {
        private final IDocument document;
        private final ArrayList<Integer> hashes;

        public LineComparator(IDocument document) {
            this.document = document;
            this.hashes = new ArrayList<Integer>(Arrays.asList(new Integer[document.getNumberOfLines()]));
        }

        public int getRangeCount() {
            return this.document.getNumberOfLines();
        }

        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            try {
                return this.getHash(thisIndex).equals(((LineComparator)other).getHash(otherIndex));
            }
            catch (BadLocationException e) {
                log.error("Problem comparing", (Throwable)e);
                return false;
            }
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }

        private Integer getHash(int line) throws BadLocationException {
            Integer hash = this.hashes.get(line);
            if (hash == null) {
                IRegion lineRegion = this.document.getLineInformation(line);
                String lineContents = this.document.get(lineRegion.getOffset(), lineRegion.getLength());
                hash = this.computeDJBHash(lineContents);
                this.hashes.set(line, hash);
            }
            return hash;
        }

        private int computeDJBHash(String string) {
            int hash = 5381;
            int len = string.length();
            int i = 0;
            while (i < len) {
                hash = (hash << 5) + hash + string.charAt(i);
                ++i;
            }
            return hash;
        }
    }
}

