/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@Deprecated
public class NewSourceFolderDialog
extends StatusDialog {
    private SelectionButtonDialogField fUseProjectButton;
    private SelectionButtonDialogField fUseFolderButton;
    private StringDialogField fContainerDialogField;
    private StatusInfo fContainerFieldStatus;
    private IContainer fFolder;
    private List<IContainer> fExistingFolders;
    private IProject fCurrProject;

    public NewSourceFolderDialog(Shell parent, String title, IProject project, List<IContainer> existingFolders, CPElement entryToEdit) {
        super(parent);
        this.setTitle(title);
        this.fContainerFieldStatus = new StatusInfo();
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        this.fUseProjectButton = new SelectionButtonDialogField(16);
        this.fUseProjectButton.setLabelText(CPathEntryMessages.NewSourceFolderDialog_useproject_button);
        this.fUseProjectButton.setDialogFieldListener(adapter);
        this.fUseFolderButton = new SelectionButtonDialogField(16);
        this.fUseFolderButton.setLabelText(CPathEntryMessages.NewSourceFolderDialog_usefolder_button);
        this.fUseFolderButton.setDialogFieldListener(adapter);
        this.fContainerDialogField = new StringDialogField();
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fContainerDialogField.setLabelText(CPathEntryMessages.NewSourceFolderDialog_sourcefolder_label);
        this.fUseFolderButton.attachDialogField(this.fContainerDialogField);
        this.fFolder = null;
        this.fExistingFolders = existingFolders;
        this.fCurrProject = project;
        boolean useFolders = true;
        if (entryToEdit == null) {
            this.fContainerDialogField.setText("");
        } else {
            IPath editPath = entryToEdit.getPath().removeFirstSegments(1);
            this.fContainerDialogField.setText(editPath.toString());
            useFolders = !editPath.isEmpty();
        }
        this.fUseFolderButton.setSelection(useFolders);
        this.fUseProjectButton.setSelection(!useFolders);
        this.setHelpAvailable(false);
    }

    public void setMessage(String message) {
        this.fContainerDialogField.setLabelText(message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        inner.setLayout((Layout)layout);
        int widthHint = this.convertWidthInCharsToPixels(50);
        GridData data = new GridData(768);
        data.widthHint = widthHint;
        if (this.fExistingFolders.contains(this.fCurrProject)) {
            this.fContainerDialogField.doFillIntoGrid(inner, 2);
        } else {
            int horizontalIndent;
            this.fUseProjectButton.doFillIntoGrid(inner, 1);
            this.fUseFolderButton.doFillIntoGrid(inner, 1);
            this.fContainerDialogField.getTextControl(inner);
            data.horizontalIndent = horizontalIndent = this.convertWidthInCharsToPixels(3);
        }
        Text control = this.fContainerDialogField.getTextControl(null);
        control.setLayoutData((Object)data);
        this.fContainerDialogField.postSetFocusOnDialogField(parent.getDisplay());
        NewSourceFolderDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.updateStatus(this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fFolder = null;
        IProject folder = null;
        if (this.fUseFolderButton.isSelected()) {
            String pathStr = this.fContainerDialogField.getText();
            if (pathStr.length() == 0) {
                this.fContainerFieldStatus.setError(CPathEntryMessages.NewSourceFolderDialog_error_enterpath);
                return;
            }
            IPath path = this.fCurrProject.getFullPath().append(pathStr);
            IWorkspace workspace = this.fCurrProject.getWorkspace();
            IStatus pathValidation = workspace.validatePath(path.toString(), 2);
            if (!pathValidation.isOK()) {
                this.fContainerFieldStatus.setError(NLS.bind((String)CPathEntryMessages.NewSourceFolderDialog_error_invalidpath, (Object)pathValidation.getMessage()));
                return;
            }
            folder = this.fCurrProject.getFolder(pathStr);
        } else {
            folder = this.fCurrProject;
        }
        if (this.isExisting((IContainer)folder)) {
            this.fContainerFieldStatus.setError(CPathEntryMessages.NewSourceFolderDialog_error_pathexists);
            return;
        }
        this.fContainerFieldStatus.setOK();
        this.fFolder = folder;
    }

    private boolean isExisting(IContainer folder) {
        return this.fExistingFolders.contains(folder);
    }

    public IContainer getSourceFolder() {
        return this.fFolder;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    private class SourceContainerAdapter
    implements IDialogFieldListener {
        private SourceContainerAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewSourceFolderDialog.this.doStatusLineUpdate();
        }
    }
}

