/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.QMLModuleResolver;
import org.eclipse.cdt.internal.qt.core.QmlASTNodeHandler;
import org.eclipse.cdt.qt.core.IQMLAnalyzer;
import org.eclipse.cdt.qt.core.QMLTernCompletion;
import org.eclipse.cdt.qt.core.qmljs.IQmlASTNode;

public class QMLAnalyzer
implements IQMLAnalyzer {
    private QMLModuleResolver moduleResolver;
    private ScriptEngine engine;
    private Boolean supported;
    private Invocable invoke;
    private Object tern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws ScriptException, IOException, NoSuchMethodException {
        this.moduleResolver = new QMLModuleResolver(this);
        this.engine = new ScriptEngineManager().getEngineByName("nashorn");
        if (this.engine == null) {
            QMLAnalyzer qMLAnalyzer = this;
            synchronized (qMLAnalyzer) {
                this.supported = false;
                this.notifyAll();
            }
            throw new ScriptException("Nashorn script engine is not available in Java 15 and above. The QML Analyzer is not supported.");
        }
        this.invoke = (Invocable)((Object)this.engine);
        this.loadDep("/tern-qml/node_modules/acorn/dist/acorn.js");
        this.loadDep("/tern-qml/node_modules/acorn/dist/acorn_loose.js");
        this.loadDep("/tern-qml/node_modules/acorn/dist/walk.js");
        this.loadDep("/tern-qml/node_modules/tern/lib/signal.js");
        this.loadDep("/tern-qml/node_modules/tern/lib/tern.js");
        this.loadDep("/tern-qml/node_modules/tern/lib/def.js");
        this.loadDep("/tern-qml/node_modules/tern/lib/comment.js");
        this.loadDep("/tern-qml/node_modules/tern/lib/infer.js");
        this.load("/acorn-qml/inject.js");
        this.load("/acorn-qml/index.js");
        this.load("/acorn-qml/loose/inject.js");
        this.load("/acorn-qml/loose/index.js");
        this.load("/acorn-qml/walk/index.js");
        this.load("/tern-qml/qml.js");
        this.load("/tern-qml/qml-nsh.js");
        Bindings options = (Bindings)this.engine.eval("new Object()");
        options.put("ecmaVersion", (Object)5);
        Bindings plugins = (Bindings)this.engine.eval("new Object()");
        plugins.put("qml", (Object)true);
        options.put("plugins", (Object)plugins);
        Bindings defs = (Bindings)this.engine.eval("new Array()");
        this.load("/tern-qml/ecma5-defs.js");
        this.invoke.invokeMethod(defs, "push", this.engine.get("ecma5defs"));
        options.put("defs", (Object)defs);
        ResolveDirectory resolveDirectory = (file, pathString) -> {
            String filename = (String)file.get("name");
            String fileDirectory = new File(filename).getParent();
            if (fileDirectory == null) {
                fileDirectory = "";
            }
            if (pathString == null) {
                return this.fixPathString(fileDirectory);
            }
            Path fileDirectoryPath = Paths.get(fileDirectory, new String[0]);
            Path path = Paths.get(pathString, new String[0]);
            if (!path.isAbsolute()) {
                path = fileDirectoryPath.toAbsolutePath().resolve(path);
            }
            return this.fixPathString(path.normalize().toString());
        };
        options.put("resolveDirectory", this.invoke.invokeFunction("resolveDirectory", resolveDirectory));
        options.put("resolveModule", this.invoke.invokeFunction("resolveModule", this.moduleResolver));
        QMLAnalyzer qMLAnalyzer = this;
        synchronized (qMLAnalyzer) {
            this.tern = this.invoke.invokeFunction("newTernServer", options);
            this.supported = this.tern != null;
            this.notifyAll();
        }
    }

    private Object load(String file) throws ScriptException, IOException {
        URL scriptURL = Activator.getDefault().getBundle().getEntry(file);
        if (scriptURL == null) {
            throw new FileNotFoundException(file);
        }
        this.engine.getContext().setAttribute("javax.script.filename", file, 100);
        return this.engine.eval(new BufferedReader(new InputStreamReader(scriptURL.openStream(), StandardCharsets.UTF_8)));
    }

    private Object loadDep(String file) throws ScriptException, IOException {
        try {
            return this.load(file);
        }
        catch (FileNotFoundException e) {
            return this.load(file.replace("/tern-qml/node_modules/", "/tern-qml/dist/"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSupported() {
        QMLAnalyzer qMLAnalyzer = this;
        synchronized (qMLAnalyzer) {
            while (this.supported == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                    return false;
                }
            }
            return this.supported;
        }
    }

    private void waitUntilLoaded() throws ScriptException {
        if (!this.isSupported()) {
            throw new ScriptException("Nashorn script engine is not available in Java 15 and above. The QML Analyzer is not supported.");
        }
    }

    private String fixPathString(String fileName) {
        if ((fileName = fileName.replaceAll("\\\\", "/")).startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    @Override
    public void addFile(String fileName, String code) throws NoSuchMethodException, ScriptException {
        this.waitUntilLoaded();
        this.invoke.invokeMethod(this.tern, "addFile", this.fixPathString(fileName), code);
    }

    @Override
    public void deleteFile(String fileName) throws NoSuchMethodException, ScriptException {
        this.waitUntilLoaded();
        this.invoke.invokeMethod(this.tern, "delFile", this.fixPathString(fileName));
    }

    @Override
    public IQmlASTNode parseFile(String fileName, String text) throws NoSuchMethodException, ScriptException {
        this.waitUntilLoaded();
        fileName = this.fixPathString(fileName);
        Bindings query = this.engine.createBindings();
        query.put("type", (Object)"parseFile");
        query.put("file", (Object)fileName);
        Bindings request = this.engine.createBindings();
        request.put("query", (Object)query);
        if (text != null) {
            Bindings file = this.engine.createBindings();
            file.put("type", (Object)"full");
            file.put("name", (Object)fileName);
            file.put("text", (Object)text);
            Bindings files = (Bindings)this.engine.eval("new Array()");
            this.invoke.invokeMethod(files, "push", file);
            request.put("files", (Object)files);
        }
        ASTCallback callback = new ASTCallback();
        this.invoke.invokeMethod(this.tern, "request", request, this.invoke.invokeFunction("requestCallback", callback));
        return callback.getAST();
    }

    @Override
    public IQmlASTNode parseString(String text) throws NoSuchMethodException, ScriptException {
        return this.parseString(text, "qml", false, false);
    }

    @Override
    public IQmlASTNode parseString(String text, String mode, boolean locations, boolean ranges) throws NoSuchMethodException, ScriptException {
        this.waitUntilLoaded();
        Bindings options = this.engine.createBindings();
        options.put("mode", (Object)mode);
        options.put("locations", (Object)locations);
        options.put("ranges", (Object)ranges);
        ASTCallback callback = new ASTCallback();
        this.invoke.invokeMethod(this.tern, "parseString", text, options, this.invoke.invokeFunction("requestCallback", callback));
        return callback.getAST();
    }

    protected <T> T[] toJavaArray(Bindings binding, Class<T[]> clazz) throws NoSuchMethodException, ScriptException {
        return clazz.cast(this.invoke.invokeMethod(this.engine.get("Java"), "to", binding, String.valueOf(clazz.getCanonicalName()) + (clazz.isArray() ? "" : "[]")));
    }

    @Override
    public Collection<QMLTernCompletion> getCompletions(String fileName, String text, int pos) throws NoSuchMethodException, ScriptException {
        return this.getCompletions(fileName, text, pos, true);
    }

    @Override
    public Collection<QMLTernCompletion> getCompletions(String fileName, String text, int pos, boolean includeKeywords) throws NoSuchMethodException, ScriptException {
        this.waitUntilLoaded();
        fileName = this.fixPathString(fileName);
        Bindings query = this.engine.createBindings();
        query.put("type", (Object)"completions");
        query.put("lineCharPositions", (Object)true);
        query.put("file", (Object)fileName);
        query.put("end", (Object)pos);
        query.put("types", (Object)true);
        query.put("docs", (Object)false);
        query.put("urls", (Object)false);
        query.put("origins", (Object)true);
        query.put("filter", (Object)true);
        query.put("caseInsensitive", (Object)true);
        query.put("guess", (Object)false);
        query.put("sort", (Object)true);
        query.put("expandWordForward", (Object)false);
        query.put("includeKeywords", (Object)includeKeywords);
        Bindings request = this.engine.createBindings();
        request.put("query", (Object)query);
        if (text != null) {
            Bindings file = this.engine.createBindings();
            file.put("type", (Object)"full");
            file.put("name", (Object)fileName);
            file.put("text", (Object)text);
            Bindings files = (Bindings)this.engine.eval("new Array()");
            this.invoke.invokeMethod(files, "push", file);
            request.put("files", (Object)files);
        }
        ArrayList<QMLTernCompletion> completions = new ArrayList<QMLTernCompletion>();
        RequestCallback callback = (err, data) -> {
            if (err != null) {
                throw new RuntimeException(err.toString());
            }
            try {
                Bindings comps = (Bindings)((Bindings)data).get("completions");
                Bindings[] bindingsArray = (Bindings[])this.toJavaArray(comps, Bindings[].class);
                int n = bindingsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bindings completion = bindingsArray[n2];
                    completions.add(new QMLTernCompletion((String)completion.get("name"), (String)completion.get("type"), (String)completion.get("origin")));
                    ++n2;
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
        this.invoke.invokeMethod(this.tern, "request", request, this.invoke.invokeFunction("requestCallback", callback));
        return completions;
    }

    @Override
    public List<Bindings> getDefinition(String identifier, String fileName, String text, int pos) throws NoSuchMethodException, ScriptException {
        this.waitUntilLoaded();
        fileName = this.fixPathString(fileName);
        Bindings query = this.engine.createBindings();
        query.put("type", (Object)"definition");
        query.put("file", (Object)fileName);
        query.put("end", (Object)pos);
        query.put("types", (Object)true);
        query.put("docs", (Object)false);
        query.put("urls", (Object)false);
        query.put("origins", (Object)true);
        query.put("caseInsensitive", (Object)true);
        query.put("lineCharPositions", (Object)true);
        query.put("expandWordForward", (Object)false);
        query.put("includeKeywords", (Object)true);
        query.put("guess", (Object)false);
        Bindings request = this.engine.createBindings();
        request.put("query", (Object)query);
        if (text != null) {
            Bindings file = this.engine.createBindings();
            file.put("type", (Object)"full");
            file.put("name", (Object)fileName);
            file.put("text", (Object)text);
            Bindings files = (Bindings)this.engine.eval("new Array()");
            this.invoke.invokeMethod(files, "push", file);
            request.put("files", (Object)files);
        }
        ArrayList<Bindings> definitions = new ArrayList<Bindings>();
        RequestCallback callback = (err, data) -> {
            if (err != null) {
                throw new RuntimeException(err.toString());
            }
            definitions.add((Bindings)data);
        };
        this.invoke.invokeMethod(this.tern, "request", request, this.invoke.invokeFunction("requestCallback", callback));
        return definitions;
    }

    private static class ASTCallback
    implements RequestCallback {
        private IQmlASTNode ast;

        private ASTCallback() {
        }

        @Override
        public void callback(Object err, Object data) {
            if (err != null) {
                throw new RuntimeException(err.toString());
            }
            try {
                this.ast = QmlASTNodeHandler.createQmlASTProxy((Bindings)((Bindings)data).get("ast"));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        public IQmlASTNode getAST() {
            return this.ast;
        }
    }

    @FunctionalInterface
    public static interface RequestCallback {
        public void callback(Object var1, Object var2);
    }

    @FunctionalInterface
    public static interface ResolveDirectory {
        public String resolveDirectory(Bindings var1, String var2);
    }
}

