/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.apache.ode.deploy.ui.util;

import org.eclipse.bpel.apache.ode.deploy.model.dd.ProcessType;
import org.eclipse.bpel.apache.ode.deploy.ui.util.DeployUtils;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.wsdl.PortType;

public class InterfaceTableListener
implements Listener {
    protected ProcessType processType = null;
    protected Table table = null;
    protected TableEditor editor = null;
    protected FormToolkit toolkit = null;
    protected IWorkbenchPage page = null;
    protected boolean isInbound = false;

    public InterfaceTableListener(ProcessType fProcessType, Table fTable, TableEditor fEditor, FormToolkit fToolkit, IWorkbenchPage fPage, boolean bIsInbound) {
        this.processType = fProcessType;
        this.table = fTable;
        this.editor = fEditor;
        this.toolkit = fToolkit;
        this.page = fPage;
        this.isInbound = bIsInbound;
    }

    public void handleEvent(Event event) {
        Rectangle clientArea = this.table.getClientArea();
        Point pt = new Point(event.x, event.y);
        int index = this.table.getTopIndex();
        while (index < this.table.getItemCount()) {
            boolean visible = false;
            final TableItem item = this.table.getItem(index);
            int i = 0;
            while (i < this.table.getColumnCount()) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt)) {
                    final int column = i;
                    System.out.println("A cell in column " + (i + 1) + " has been pressed");
                    if (i == 0) {
                        System.out.println("PORT_TYPE_COLUMN has been pressed");
                        Hyperlink link = this.toolkit.createHyperlink((Composite)this.table, "", 0);
                        HyperlinkAdapter listener = new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent e) {
                                System.out.println("Hyper clicked!");
                                String partnerLinkName = e.getLabel();
                                PartnerLink theOne = null;
                                PartnerLinks partnerLinksElm = InterfaceTableListener.this.processType.getModel().getPartnerLinks();
                                EList partnerLinks = partnerLinksElm.getChildren();
                                for (PartnerLink currentPL : partnerLinks) {
                                    if (!currentPL.getName().equals(partnerLinkName)) continue;
                                    theOne = currentPL;
                                    break;
                                }
                                if (theOne != null) {
                                    Role role = null;
                                    role = InterfaceTableListener.this.isInbound ? theOne.getMyRole() : theOne.getPartnerRole();
                                    if (role != null) {
                                        PortType portType = (PortType)role.getPortType();
                                        Resource resource = portType.eResource();
                                        IFile file = DeployUtils.getIFileForURI(resource.getURI());
                                        try {
                                            IDE.openEditor((IWorkbenchPage)InterfaceTableListener.this.page, (IFile)file);
                                        }
                                        catch (PartInitException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }
                            }
                        };
                        link.addHyperlinkListener((IHyperlinkListener)listener);
                        this.editor.setEditor((Control)link, item, i);
                        link.setText(item.getText(i));
                        link.setFocus();
                    } else {
                        final Text text = new Text((Composite)this.table, 0);
                        Listener textListener = new Listener(){

                            public void handleEvent(Event e) {
                                switch (e.type) {
                                    case 16: {
                                        item.setText(column, text.getText());
                                        text.dispose();
                                        break;
                                    }
                                    case 31: {
                                        switch (e.detail) {
                                            case 4: {
                                                item.setText(column, text.getText());
                                            }
                                            case 2: {
                                                text.dispose();
                                                e.doit = false;
                                            }
                                        }
                                    }
                                }
                            }
                        };
                        text.addListener(16, textListener);
                        text.addListener(31, textListener);
                        this.editor.setEditor((Control)text, item, i);
                        text.setText(item.getText(i));
                        text.selectAll();
                        text.setFocus();
                    }
                    return;
                }
                if (!visible && rect.intersects(clientArea)) {
                    visible = true;
                }
                ++i;
            }
            if (!visible) {
                return;
            }
            ++index;
        }
    }
}

