/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.testers;

import java.io.File;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.ContentTypeHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;

public class FSTreeNodePropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Property prop;
        if (receiver == null) {
            return false;
        }
        try {
            prop = Property.valueOf(property);
        }
        catch (Exception exception) {
            return false;
        }
        Assert.isTrue((boolean)(receiver instanceof FSTreeNode));
        FSTreeNode node = (FSTreeNode)receiver;
        switch (prop) {
            case getCacheState: {
                File file = CacheManager.getCacheFile(node);
                if (!file.exists()) {
                    return false;
                }
                CacheState state = node.getCacheState();
                return state.name().equals(expectedValue);
            }
            case isBinaryFile: {
                return ContentTypeHelper.isBinaryFile(node);
            }
            case isDirectory: {
                return node.isDirectory();
            }
            case isExecutable: {
                return node.isExecutable();
            }
            case isRevealOnConnect: {
                return node.isRevealOnConnect();
            }
            case isFile: {
                return node.isFile();
            }
            case isHidden: {
                return node.isHidden();
            }
            case isReadOnly: {
                return node.isReadOnly();
            }
            case isReadable: {
                return node.isReadable();
            }
            case isRoot: {
                return node.isRootDirectory();
            }
            case isSystemRoot: {
                return node.isFileSystem();
            }
            case isWindows: {
                return node.isWindowsNode();
            }
            case isWritable: {
                return node.isWritable();
            }
            case testParent: {
                return this.testParent(node, args, expectedValue);
            }
        }
        return false;
    }

    private boolean testParent(FSTreeNode node, Object[] args, Object expectedValue) {
        if (args == null || args.length == 0) {
            return false;
        }
        String arg = (String)args[0];
        Object[] newArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        return this.test(node.getParent(), arg, newArgs, expectedValue);
    }

    private static enum Property {
        isFile,
        isDirectory,
        isBinaryFile,
        isReadable,
        isWritable,
        isExecutable,
        isRoot,
        isSystemRoot,
        isWindows,
        isReadOnly,
        isHidden,
        testParent,
        getCacheState,
        isRevealOnConnect;

    }
}

