/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.handler;

import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.reddeer.gef.api.Palette;
import org.eclipse.reddeer.gef.finder.EditPartFinder;
import org.eclipse.reddeer.gef.impl.palette.internal.BasicPalette;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class ViewerHandler {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static ViewerHandler instance;

    public static ViewerHandler getInstance() {
        if (instance == null) {
            instance = new ViewerHandler();
        }
        return instance;
    }

    public Palette getPalette(final GraphicalViewer viewer) {
        PaletteViewer paletteViewer = (PaletteViewer)Display.syncExec((ResultRunnable)new ResultRunnable<PaletteViewer>(){

            public PaletteViewer run() {
                return viewer.getEditDomain().getPaletteViewer();
            }
        });
        return new BasicPalette(paletteViewer);
    }

    public List<EditPart> getEditParts(GraphicalViewer viewer) {
        return this.getEditParts((EditPartViewer)viewer, (Matcher<EditPart>)new Any());
    }

    public List<EditPart> getEditParts(final EditPartViewer viewer, final Matcher<EditPart> matcher) {
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<EditPart>>(){

            public List<EditPart> run() {
                EditPart root = viewer.getContents();
                return new EditPartFinder().find(root, matcher);
            }
        });
    }

    public void click(EditPartViewer viewer, int x, int y) {
        this.log.info("Click at [" + x + ", " + y + "]");
        FigureCanvas figureCanvas = this.getFigureCanvas(viewer);
        WidgetHandler.getInstance().notifyItemMouse(5, 0, (Widget)figureCanvas, null, x, y, 0);
        WidgetHandler.getInstance().notifyItemMouse(3, 0, (Widget)figureCanvas, null, x, y, 1);
        WidgetHandler.getInstance().notifyItemMouse(4, 0, (Widget)figureCanvas, null, x, y, 1);
    }

    public FigureCanvas getFigureCanvas(EditPartViewer viewer) {
        return (FigureCanvas)viewer.getControl();
    }

    private class Any
    extends BaseMatcher<EditPart> {
        private Any() {
        }

        public boolean matches(Object item) {
            return true;
        }

        public void describeTo(Description description) {
        }
    }
}

