/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.handlers;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.ScopeType;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.presentation.handlers.OpenEditorDropdownHandler;
import org.eclipse.oomph.setup.ui.SetupLabelProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;

public class OpenEditorDropdownFactory
extends CompoundContributionItem {
    protected final IContributionItem[] getContributionItems() {
        return new IContributionItem[]{new DropDownItem()};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DropDownItem
    extends ContributionItem {
        public DropDownItem() {
            super(OpenEditorDropdownFactory.class.getSimpleName());
        }

        public void fill(Menu menu, int index) {
            try {
                ProductVersion productVersion;
                Workspace workspace;
                HashSet<Object> eObjects = new HashSet<Object>();
                final LinkedHashSet<EObject> parents = new LinkedHashSet<EObject>();
                ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
                SetupContext setupContext = SetupContext.getSelf();
                User user = setupContext.getUser();
                this.createMenuItem(menu, adapterFactory, (EObject)user);
                eObjects.add(user);
                Installation installation = setupContext.getInstallation();
                if (installation != null) {
                    this.createMenuItem(menu, adapterFactory, (EObject)installation);
                    eObjects.add(installation);
                }
                if ((workspace = setupContext.getWorkspace()) != null) {
                    this.createMenuItem(menu, adapterFactory, (EObject)workspace);
                    eObjects.add(workspace);
                }
                if (installation != null && (productVersion = installation.getProductVersion()) != null) {
                    new MenuItem(menu, 2);
                    this.createMenuItem(menu, adapterFactory, (EObject)productVersion);
                    eObjects.add(productVersion);
                    this.addParents(parents, (EObject)productVersion);
                }
                if (workspace != null && !workspace.getStreams().isEmpty()) {
                    new MenuItem(menu, 2);
                    for (Stream stream : workspace.getStreams()) {
                        this.createMenuItem(menu, adapterFactory, (EObject)stream);
                        eObjects.add(stream);
                        this.addParents(parents, (EObject)stream);
                    }
                }
                adapterFactory.dispose();
                parents.removeAll(eObjects);
                if (!parents.isEmpty()) {
                    new MenuItem(menu, 2);
                    final Menu subMenu = new Menu(menu);
                    subMenu.addMenuListener((MenuListener)new MenuAdapter(){

                        public void menuShown(MenuEvent e) {
                            Menu m = (Menu)e.widget;
                            MenuItem[] items = m.getItems();
                            int i = 0;
                            while (i < items.length) {
                                items[i].dispose();
                                ++i;
                            }
                            ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
                            int lastCategory = 0;
                            for (EObject eObject : parents) {
                                int category = this.getCategory(eObject);
                                if (category != lastCategory) {
                                    new MenuItem(subMenu, 2);
                                    lastCategory = category;
                                }
                                DropDownItem.this.createMenuItem(subMenu, adapterFactory, eObject);
                            }
                            adapterFactory.dispose();
                        }

                        private int getCategory(EObject eObject) {
                            Scope scope;
                            ScopeType type;
                            if (eObject instanceof Scope && (type = (scope = (Scope)eObject).getType()) != null) {
                                switch (type) {
                                    case PRODUCT_CATALOG: 
                                    case PRODUCT: 
                                    case PRODUCT_VERSION: {
                                        return 1;
                                    }
                                    case PROJECT_CATALOG: 
                                    case PROJECT: 
                                    case STREAM: {
                                        return 2;
                                    }
                                }
                            }
                            return 0;
                        }
                    });
                    MenuItem menuItem = new MenuItem(menu, 64);
                    menuItem.setText("Parent Models");
                    menuItem.setMenu(subMenu);
                }
            }
            catch (Exception ex) {
                SetupEditorPlugin.getPlugin().log(ex);
            }
        }

        private void addParents(Set<EObject> parentResources, EObject object) {
            EObject parent = object.eContainer();
            if (parent != null) {
                this.addParents(parentResources, parent);
            }
            if (object instanceof Scope || object instanceof Index) {
                parentResources.add(object);
            }
        }

        private MenuItem createMenuItem(Menu menu, ComposedAdapterFactory adapterFactory, final EObject object) {
            ItemProviderAdapter itemProvider = (ItemProviderAdapter)adapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
            ImageDescriptor imageDescriptor = SetupLabelProvider.getImageDescriptor((ItemProviderAdapter)itemProvider, (EObject)object);
            String text = OpenEditorDropdownHandler.getLabelText(itemProvider, object, !"org.eclipse.oomph.setup.editor.open.menu.dynamic".equals(OpenEditorDropdownFactory.this.getId()));
            MenuItem item = new MenuItem(menu, 8);
            item.setImage(ExtendedImageRegistry.INSTANCE.getImage((Object)imageDescriptor));
            item.setText(text);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenEditorDropdownHandler.openEditor(object);
                }
            });
            return item;
        }
    }
}

