/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class SelectionUtil {
    public static @Nullable Notifier getNotifierSelection(@Nullable ISelection selection, @Nullable IWorkbenchPart part) {
        Notifier input = null;
        if (selection instanceof ITreeSelection) {
            input = SelectionUtil.getTreeSelection((ITreeSelection)selection, part);
        } else if (selection instanceof IStructuredSelection) {
            input = SelectionUtil.getStructureSelection((IStructuredSelection)selection, part);
        } else if (selection instanceof ITextSelection) {
            input = SelectionUtil.getTextSelection((ITextSelection)selection, part);
        }
        return input;
    }

    public static @Nullable Notifier getTreeSelection(@NonNull ITreeSelection selection, @Nullable IWorkbenchPart part) {
        if (selection.size() == 1) {
            Object adaptedElement;
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof Notifier) {
                return (Notifier)firstElement;
            }
            if (firstElement instanceof IAdaptable && (adaptedElement = ((IAdaptable)firstElement).getAdapter(EObject.class)) instanceof Notifier) {
                return (Notifier)adaptedElement;
            }
            if (firstElement instanceof EObjectNode) {
                return SelectionUtil.getXtextOutlineSelection((EObjectNode)firstElement, part);
            }
        }
        return null;
    }

    public static @Nullable Notifier getStructureSelection(@NonNull IStructuredSelection selection, @Nullable IWorkbenchPart part) {
        if (selection.size() == 1) {
            Object adaptedElement;
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof Notifier) {
                return (Notifier)firstElement;
            }
            if (firstElement instanceof IAdaptable && (adaptedElement = ((IAdaptable)firstElement).getAdapter(EObject.class)) instanceof Notifier) {
                return (Notifier)adaptedElement;
            }
            if (firstElement instanceof EObjectNode) {
                return SelectionUtil.getXtextOutlineSelection((EObjectNode)firstElement, part);
            }
        }
        return null;
    }

    public static @Nullable Notifier getTextSelection(final @NonNull ITextSelection selection, @Nullable IWorkbenchPart part) {
        if (selection.getStartLine() < 0 || selection.getEndLine() < 0) {
            return null;
        }
        if (!(part instanceof XtextEditor)) {
            return null;
        }
        IXtextDocument document = ((XtextEditor)part).getDocument();
        Notifier selectedObject = (Notifier)document.readOnly((IUnitOfWork)new IUnitOfWork<Notifier, XtextResource>(){

            public Notifier exec(@Nullable XtextResource xtextResource) {
                if (xtextResource == null) {
                    return null;
                }
                IParseResult parseResult = xtextResource.getParseResult();
                if (parseResult == null) {
                    throw new NullPointerException("parseResult is null");
                }
                ICompositeNode rootNode = parseResult.getRootNode();
                ILeafNode lastVisibleNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)selection.getOffset());
                if (lastVisibleNode == null) {
                    return null;
                }
                EObject currentModel = NodeModelUtils.findActualSemanticObjectFor((INode)lastVisibleNode);
                return currentModel;
            }
        });
        return selectedObject;
    }

    public static @Nullable Notifier getXtextOutlineSelection(@NonNull EObjectNode selection, @Nullable IWorkbenchPart part) {
        if (!(part instanceof XtextEditor)) {
            return null;
        }
        final URI selectedURI = selection.getEObjectURI();
        IXtextDocument document = ((XtextEditor)part).getDocument();
        Notifier selectedObject = (Notifier)document.readOnly((IUnitOfWork)new IUnitOfWork<Notifier, XtextResource>(){

            public Notifier exec(@Nullable XtextResource xtextResource) {
                if (xtextResource == null) {
                    return null;
                }
                EObject eObject = xtextResource.getEObject(selectedURI.fragment());
                return eObject;
            }
        });
        return selectedObject;
    }
}

