/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.objectteams.otredyn.bytecode.asm.MultiClassAdapter;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class AddGlobalTeamActivationAdapter
extends ClassVisitor {
    private static final String TEAM_CONFIG_FILE = System.getProperty("ot.teamconfig");
    private static final String COMMENT_MARKER = "#";
    private static boolean done = false;

    private AddGlobalTeamActivationAdapter(ClassVisitor cv) {
        super(524288, cv);
    }

    public static synchronized void checkAddVisitor(MultiClassAdapter multiAdapter, ClassWriter writer) {
        if (done || TEAM_CONFIG_FILE == null) {
            return;
        }
        multiAdapter.addVisitor(new AddGlobalTeamActivationAdapter((ClassVisitor)writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Class<AddGlobalTeamActivationAdapter> clazz = AddGlobalTeamActivationAdapter.class;
        synchronized (AddGlobalTeamActivationAdapter.class) {
            if (!done && this.isMainMethod(name, desc, access)) {
                done = true;
                final MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, null, null);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return new AdviceAdapter(this.api, methodVisitor, access, name, desc){

                    protected void onMethodEnter() {
                        List teams = AddGlobalTeamActivationAdapter.getTeamsFromConfigFile();
                        for (String aTeam : teams) {
                            String aTeamSlash = aTeam.replace('.', '/');
                            Label start = new Label();
                            methodVisitor.visitLabel(start);
                            methodVisitor.visitTypeInsn(187, aTeamSlash);
                            methodVisitor.visitInsn(89);
                            methodVisitor.visitMethodInsn(183, aTeamSlash, "<init>", "()V", false);
                            methodVisitor.visitFieldInsn(178, ClassNames.TEAM_SLASH, "ALL_THREADS", "Ljava/lang/Thread;");
                            methodVisitor.visitMethodInsn(182, aTeamSlash, "activate", "(Ljava/lang/Thread;)V", false);
                            Label end = new Label();
                            methodVisitor.visitLabel(end);
                            Label after = new Label();
                            methodVisitor.visitJumpInsn(167, after);
                            Label typeHandler = new Label();
                            methodVisitor.visitLabel(typeHandler);
                            methodVisitor.visitInsn(87);
                            methodVisitor.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
                            methodVisitor.visitLdcInsn((Object)("Config error: Team class '" + aTeam + "' in config file '" + TEAM_CONFIG_FILE + "' can not be found!"));
                            methodVisitor.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
                            methodVisitor.visitJumpInsn(167, after);
                            methodVisitor.visitTryCatchBlock(start, end, typeHandler, "java/lang/ClassNotFoundException");
                            typeHandler = new Label();
                            methodVisitor.visitLabel(typeHandler);
                            methodVisitor.visitInsn(87);
                            methodVisitor.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
                            methodVisitor.visitLdcInsn((Object)("Config error: Team class '" + aTeam + "' in config file '" + TEAM_CONFIG_FILE + "' can not be found!"));
                            methodVisitor.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
                            methodVisitor.visitJumpInsn(167, after);
                            methodVisitor.visitTryCatchBlock(start, end, typeHandler, "java/lang/NoClassDefFoundError");
                            Label ctorHandler = new Label();
                            methodVisitor.visitLabel(ctorHandler);
                            methodVisitor.visitInsn(87);
                            methodVisitor.visitFieldInsn(178, "java/lang/System", "err", "Ljava/io/PrintStream;");
                            methodVisitor.visitLdcInsn((Object)("Activation failed: Team class '" + aTeam + "' has no default constuctor!"));
                            methodVisitor.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
                            methodVisitor.visitTryCatchBlock(start, end, ctorHandler, "java/lang/NoSuchMethodError");
                            methodVisitor.visitLabel(after);
                        }
                    }

                    public void visitMaxs(int maxStack, int maxLocals) {
                        super.visitMaxs(Math.max(maxStack, 3), maxLocals);
                    }
                };
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return null;
        }
    }

    private boolean isMainMethod(String name, String desc, int access) {
        if (access != 9) {
            return false;
        }
        if (!"main".equals(name)) {
            return false;
        }
        return "([Ljava/lang/String;)V".equals(desc);
    }

    private static List<String> getTeamsFromConfigFile() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(TEAM_CONFIG_FILE)));){
                while (in.ready()) {
                    String nextLine = in.readLine();
                    String nextTeam = nextLine.trim();
                    if (nextTeam.startsWith(COMMENT_MARKER) || nextTeam.equals("")) continue;
                    result.add(nextTeam.trim());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("File input error: config file '" + TEAM_CONFIG_FILE + "' can not be found!");
        }
        return result;
    }
}

