/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.rolefile;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings.SelectionActionCommon;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractRoleFileRefactoringAction
extends Action {
    RoleFileRefactoringActionCommon common;
    protected final String commandTooltip;
    protected final String commandName;

    protected AbstractRoleFileRefactoringAction(String commandName, String commandTooltip) {
        this.commandName = commandName;
        this.commandTooltip = commandTooltip;
    }

    public void init(IWorkbenchWindow window) {
        this.common = this.createRefactoringActionCommon(window);
    }

    protected abstract RoleFileRefactoringActionCommon createRefactoringActionCommon(IWorkbenchWindow var1);

    protected abstract RoleFileRefactoringActionCommon createRefactoringActionCommon(JavaEditor var1);

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            if (selection instanceof IStructuredSelection) {
                this.common.selectionChanged((IStructuredSelection)selection);
                action.setEnabled(this.common.isRefactoringAvailable());
            } else if (selection instanceof JavaTextSelection) {
                this.common.selectionChanged((JavaTextSelection)selection);
                action.setEnabled(this.common.isRefactoringAvailable());
            } else {
                this.common.clearJavaElement();
                action.setEnabled(true);
            }
        }
        catch (JavaModelException exception) {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        this.common.run();
    }

    protected abstract class RoleFileRefactoringActionCommon
    extends SelectionActionCommon {
        public RoleFileRefactoringActionCommon(JavaEditor editor) {
            super(editor);
        }

        public RoleFileRefactoringActionCommon(IWorkbenchWindow window) {
            super(window);
        }

        public boolean isRefactoringAvailable() throws JavaModelException {
            if (this.fJavaElement != null && this.fJavaElement.exists() && this.fJavaElement.isStructureKnown() && this.fJavaElement instanceof IType) {
                IType type = (IType)this.fJavaElement;
                return OTModelManager.isRole((IType)type);
            }
            return false;
        }
    }

    public class SelectionDispatchAction
    extends org.eclipse.jdt.ui.actions.SelectionDispatchAction {
        RoleFileRefactoringActionCommon common;

        public SelectionDispatchAction(IWorkbenchSite site) {
            super(site);
            this.common = AbstractRoleFileRefactoringAction.this.createRefactoringActionCommon(site.getWorkbenchWindow());
            this.init();
        }

        public SelectionDispatchAction(JavaEditor editor) {
            super((IWorkbenchSite)editor.getEditorSite());
            this.common = AbstractRoleFileRefactoringAction.this.createRefactoringActionCommon(editor);
            this.init();
        }

        void init() {
            this.setText(AbstractRoleFileRefactoringAction.this.commandName);
            this.setToolTipText(AbstractRoleFileRefactoringAction.this.commandTooltip);
            this.setEnabled(true);
        }

        public void selectionChanged(JavaTextSelection javaTextSelection) {
            try {
                this.common.selectionChanged(javaTextSelection);
                this.setEnabled(this.common.isRefactoringAvailable());
            }
            catch (CoreException ce) {
                this.setEnabled(false);
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            try {
                this.common.selectionChanged(selection);
                this.setEnabled(this.common.isRefactoringAvailable());
            }
            catch (JavaModelException e) {
                this.setEnabled(false);
            }
        }

        public void selectionChanged(ITextSelection selection) {
        }

        public void run() {
            this.common.run();
        }
    }
}

