/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public class TracTaskMapper
extends TaskMapper {
    private final ITracClient client;

    public TracTaskMapper(TaskData taskData, ITracClient client) {
        super(taskData);
        this.client = client;
    }

    public ITask.PriorityLevel getPriorityLevel() {
        String priority = this.getPriority();
        if (priority != null) {
            if (this.client != null) {
                TracPriority[] tracPriorities = this.client.getPriorities();
                return TracRepositoryConnector.getTaskPriority(priority, tracPriorities);
            }
            return TracRepositoryConnector.getTaskPriority(priority);
        }
        return null;
    }

    public String getTaskKind() {
        String tracTaskKind = super.getTaskKind();
        TracRepositoryConnector.TaskKind taskKind = TracRepositoryConnector.TaskKind.fromType(tracTaskKind);
        return taskKind != null ? taskKind.toString() : tracTaskKind;
    }
}

