/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewSuppressionWizard
extends Wizard
implements INewWizard {
    private static final String EXT_SUPP = "supp";
    private WizardNewFileCreationPage page;
    private IStructuredSelection selection;

    public NewSuppressionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new WizardNewFileCreationPage("newSuppressionPage", this.selection);
        this.page.setTitle(Messages.getString("NewSuppressionWizard.NewWizard_title"));
        this.page.setDescription(Messages.getString("NewSuppressionWizard.NewWizard_description"));
        this.page.setImageDescriptor((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.linuxtools.valgrind.ui.editor", (String)"icons/newsupp_wiz.png").get());
        this.page.setFileExtension(EXT_SUPP);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String containerName = this.page.getContainerFullPath().toOSString();
        String fileName = this.page.getFileName();
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.doFinish(containerName, fileName, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewSuppressionWizard.performFinish_error"), (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.getString("NewSuppressionWizard.Creating_task"), (Object)fileName), 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(NLS.bind((String)Messages.getString("NewSuppressionWizard.Container_not_exist_error"), (Object)containerName));
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (InputStream stream = this.openContentStream();){
                if (file.exists()) {
                    file.setContents(stream, true, true, monitor);
                } else {
                    file.create(stream, true, monitor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.getString("NewSuppressionWizard.Opening_file_task"));
        this.getShell().getDisplay().asyncExec(() -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        return new ByteArrayInputStream("{\n\t\n}".getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.linuxtools.valgrind.ui.editor", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

