/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser;

import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.Token;
import org.eclipse.cdt.core.dom.lrparser.IDOMTokenMap;
import org.eclipse.cdt.core.dom.lrparser.ITokenCollector;
import org.eclipse.cdt.core.dom.lrparser.LPGTokenAdapter;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;

public class CPreprocessorAdapter {
    private static final int NUM_EOC_TOKENS = 50;
    private static final int DUMMY_TOKEN_KIND = 0;
    private static final int tCOMPLETION = 140;

    public static void runCPreprocessor(IScanner preprocessor, ITokenCollector tokenCollector, IDOMTokenMap tokenMap) {
        tokenCollector.addToken(CPreprocessorAdapter.createDummyToken());
        org.eclipse.cdt.core.parser.IToken lastToken = null;
        try {
            org.eclipse.cdt.core.parser.IToken domToken;
            do {
                domToken = preprocessor.nextToken();
                CPreprocessorAdapter.processDOMToken(domToken, tokenCollector, tokenMap);
                lastToken = domToken;
            } while (domToken.getType() != 140);
        }
        catch (OffsetLimitReachedException e) {
            org.eclipse.cdt.core.parser.IToken domToken = e.getFinalToken();
            assert (domToken.getType() == 140);
            CPreprocessorAdapter.processDOMToken(domToken, tokenCollector, tokenMap);
            lastToken = domToken;
        }
        catch (EndOfFileException e) {
            // empty catch block
        }
        int eofTokenOffset = lastToken == null ? 0 : lastToken.getOffset();
        tokenCollector.addToken(CPreprocessorAdapter.createEOFToken(tokenMap, eofTokenOffset));
    }

    private static void processDOMToken(org.eclipse.cdt.core.parser.IToken domToken, ITokenCollector tokenCollector, IDOMTokenMap tokenMap) {
        int newKind = tokenMap.mapKind(domToken);
        tokenCollector.addToken(new LPGTokenAdapter(domToken, newKind));
        if (domToken.getType() == 140) {
            int offset = domToken.getOffset();
            int i = 0;
            while (i < 50) {
                tokenCollector.addToken(CPreprocessorAdapter.createEOCToken(tokenMap, offset));
                ++i;
            }
        }
    }

    private static IToken createEOCToken(IDOMTokenMap tokenMap, int offset) {
        return new Token(null, offset, offset + 1, tokenMap.getEOCTokenKind());
    }

    private static IToken createDummyToken() {
        return new Token(null, 0, 0, 0);
    }

    private static IToken createEOFToken(IDOMTokenMap tokenMap, int offset) {
        return new Token(null, offset, offset + 1, tokenMap.getEOFTokenKind());
    }
}

