/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import org.eclipse.buildship.ui.internal.util.color.ColorUtils;
import org.eclipse.buildship.ui.internal.view.task.FaultyProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.internal.view.task.TaskSelectorNode;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;

public final class TaskDescriptionLabelProvider
extends ColumnLabelProvider {
    private final Color descriptionColor = ColorUtils.getDecorationsColorFromCurrentTheme();

    public String getText(Object element) {
        if (element instanceof ProjectNode) {
            return this.getProjectTaskText((ProjectNode)element);
        }
        if (element instanceof FaultyProjectNode) {
            return this.getFaultyProjectTaskText((FaultyProjectNode)element);
        }
        if (element instanceof ProjectTaskNode) {
            return this.getProjectTaskText((ProjectTaskNode)element);
        }
        if (element instanceof TaskSelectorNode) {
            return this.getTaskSelectorText((TaskSelectorNode)element);
        }
        if (element instanceof TaskGroupNode) {
            return this.getTaskGroupText((TaskGroupNode)element);
        }
        throw new IllegalStateException(String.format("Unknown element type of element %s.", element));
    }

    private String getProjectTaskText(ProjectNode projectNode) {
        return projectNode.getEclipseProject().getDescription();
    }

    private String getFaultyProjectTaskText(FaultyProjectNode projectNode) {
        return "";
    }

    private String getTaskGroupText(TaskGroupNode taskGroup) {
        return "";
    }

    private String getProjectTaskText(ProjectTaskNode projectTask) {
        return projectTask.getDescription();
    }

    private String getTaskSelectorText(TaskSelectorNode taskSelector) {
        return taskSelector.getDescription();
    }

    public Color getForeground(Object element) {
        return this.descriptionColor;
    }
}

