/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.borders;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.borders.GradientBorder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class CollapsableBorder
extends GradientBorder {
    private boolean collapsed = false;
    protected org.eclipse.draw2d.geometry.Rectangle rectCollapsed;
    protected Image collapsedImage;
    protected Image expandedImage;
    protected int expandedWidth;
    protected int expandedHeight;
    protected Label collapsedNameLabel = null;
    protected Image image;
    protected ImageFigure imageLabel = null;
    protected IFigure parentFigure;
    protected org.eclipse.draw2d.geometry.Rectangle collapsedBounds;
    protected Point topImageLocation = new Point();
    protected Point bottomImageLocation = new Point();
    protected Point topDrawerLocation = new Point();
    protected Point bottomDrawerLocation = new Point();
    protected org.eclipse.draw2d.geometry.Rectangle collapsedRectangle;

    public CollapsableBorder(boolean isVertical, int arcWidth, IFigure parentFigure, String labelText, Image image) {
        super(isVertical, arcWidth);
        this.parentFigure = parentFigure;
        this.image = image;
        this.imageLabel = new ImageFigure(image);
        this.collapsedImage = BPELUIPlugin.INSTANCE.getImage("obj16/collapse.gif");
        this.expandedImage = BPELUIPlugin.INSTANCE.getImage("obj16/expand.gif");
        this.expandedHeight = this.expandedImage.getBounds().height;
        this.expandedWidth = this.expandedImage.getBounds().width;
        this.collapsedNameLabel = new Label(labelText);
        this.collapsedNameLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
    }

    public boolean isPointInCollapseImage(int x, int y) {
        if (!this.isCollapsed()) {
            return false;
        }
        Point p = new Point(x, y);
        this.parentFigure.translateToRelative((Translatable)p);
        org.eclipse.draw2d.geometry.Rectangle rect = this.rectCollapsed.getCopy();
        rect.expand(new Insets(1, 1, 1, 1));
        return rect.contains(p);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean showCollapse) {
        this.collapsed = showCollapse;
    }

    public void invalidate() {
        this.collapsedBounds = null;
    }

    public Label getLabel() {
        return this.collapsedNameLabel;
    }

    public void setName(String name) {
        this.collapsedNameLabel.setText(name);
    }

    protected void calculate(IFigure figure) {
        if (this.collapsedBounds == null) {
            this.collapsedBounds = figure.getBounds().getCopy();
            this.collapsedRectangle = this.collapsedBounds.getCopy();
            this.collapsedRectangle.x += 16;
            this.collapsedRectangle.width -= 32;
            this.rectCollapsed = new org.eclipse.draw2d.geometry.Rectangle(this.collapsedBounds.x + this.collapsedBounds.width / 2 - this.expandedWidth / 2, this.collapsedBounds.y + this.collapsedBounds.height - this.expandedHeight, this.expandedWidth, this.expandedHeight);
        }
    }

    @Override
    public final void paint(IFigure figure, Graphics graphics, Insets insets) {
        this.invalidate();
        this.calculate(figure);
        this.doPaint(figure, graphics, insets);
    }

    protected void doPaint(IFigure figure, Graphics graphics, Insets insets) {
        Image bottomImage;
        Image topImage;
        org.eclipse.draw2d.geometry.Rectangle oldClip = new org.eclipse.draw2d.geometry.Rectangle();
        oldClip = graphics.getClip(oldClip);
        IMarker topMarker = this.getTopMarker();
        IMarker bottomMarker = this.getBottomMarker();
        if (topMarker != null || bottomMarker != null) {
            ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
            graphics.setForegroundColor(registry.get("activityBorder"));
            org.eclipse.draw2d.geometry.Rectangle clippingRect = bottomMarker == null ? new org.eclipse.draw2d.geometry.Rectangle(this.topDrawerLocation.x, this.topDrawerLocation.y, 16, 13) : (topMarker == null ? new org.eclipse.draw2d.geometry.Rectangle(this.bottomDrawerLocation.x, this.bottomDrawerLocation.y, 16, 13) : new org.eclipse.draw2d.geometry.Rectangle(this.topDrawerLocation.x, this.topDrawerLocation.y, 16, 26));
            graphics.setClip(clippingRect);
            graphics.drawRoundRectangle(new org.eclipse.draw2d.geometry.Rectangle(this.topDrawerLocation.x + 30, this.topDrawerLocation.y, 32, 24), 7, 7);
            graphics.setClip(oldClip);
            if (bottomMarker == null || topMarker == null) {
                graphics.drawLine(this.topDrawerLocation.x + 30, this.topDrawerLocation.y + 12, this.topDrawerLocation.x + 16, this.topDrawerLocation.y + 12);
            }
        }
        if ((topImage = this.getTopImage()) != null) {
            graphics.drawImage(topImage, this.topImageLocation);
        }
        if ((bottomImage = this.getBottomImage()) != null) {
            graphics.drawImage(bottomImage, this.bottomImageLocation);
        }
    }

    @Override
    protected org.eclipse.draw2d.geometry.Rectangle getGradientRect() {
        return new org.eclipse.draw2d.geometry.Rectangle(0, 0, 0, 0);
    }

    @Override
    public boolean isPointInTopDrawer(int x, int y) {
        if (this.getTopMarker() == null) {
            return false;
        }
        Point p = new Point(x, y);
        Image image = this.getTopImage();
        Rectangle imageSize = image.getBounds();
        org.eclipse.draw2d.geometry.Rectangle imageBounds = new org.eclipse.draw2d.geometry.Rectangle(this.topImageLocation.x, this.topImageLocation.y, imageSize.width, imageSize.height);
        return imageBounds.contains(p);
    }

    @Override
    public boolean isPointInBottomDrawer(int x, int y) {
        if (this.getBottomMarker() == null) {
            return false;
        }
        Point p = new Point(x, y);
        Image image = this.getBottomImage();
        Rectangle imageSize = image.getBounds();
        org.eclipse.draw2d.geometry.Rectangle imageBounds = new org.eclipse.draw2d.geometry.Rectangle(this.bottomImageLocation.x, this.bottomImageLocation.y, imageSize.width, imageSize.height);
        return imageBounds.contains(p);
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return new Insets(0, 0, 0, 0);
    }
}

