/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.InvokeEditPart;
import org.eclipse.bpel.ui.editparts.ProcessEditPart;
import org.eclipse.bpel.ui.editparts.ScopeEditPart;
import org.eclipse.bpel.ui.editparts.borders.RoundRectangleBorderWithDecoration;
import org.eclipse.bpel.ui.editparts.policies.BPELContainerEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.ContainerHighlightEditPolicy;
import org.eclipse.bpel.ui.figures.ILayoutAware;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Image;

public class FaultHandlerEditPart
extends BPELEditPart
implements ILayoutAware {
    private Image image;
    private IFigure contentPane;
    private Border containerBorder;
    public static final int LEFT_MARGIN = 30;

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ContainerHighlightEditPolicy(false, false));
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new BPELContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BPELOrderedLayoutEditPolicy());
    }

    @Override
    protected IFigure createFigure() {
        Figure figure = new Figure();
        FlowLayout layout = new FlowLayout();
        layout.setMinorAlignment(0);
        boolean vertical = this.getModel() instanceof CompensationHandler || this.getModel() instanceof TerminationHandler;
        boolean horizontalLayout = ModelHelper.isHorizontalLayout(this.getModel());
        layout.setHorizontal(horizontalLayout ? vertical : !vertical);
        figure.setLayoutManager((LayoutManager)layout);
        if (this.image == null) {
            this.image = this.getModel() instanceof EventHandler ? BPELUIPlugin.INSTANCE.getImage("ovr16/eventhandler.gif") : (this.getModel() instanceof CompensationHandler ? BPELUIPlugin.INSTANCE.getImage("ovr16/compensationhandler.gif") : (this.getModel() instanceof TerminationHandler ? BPELUIPlugin.INSTANCE.getImage("ovr16/terminationhandler.gif") : BPELUIPlugin.INSTANCE.getImage("ovr16/faulthandler.gif")));
        }
        figure.setBorder((Border)new RoundRectangleBorderWithDecoration((IFigure)figure, this.image, new Insets(20, 10, 20, 10)));
        figure.setOpaque(true);
        this.contentPane = figure;
        int topMargin = this.calcTopMargin(horizontalLayout);
        int leftMargin = this.calcLeftMargin(horizontalLayout);
        Figure container = new Figure();
        this.containerBorder = new MarginBorder(topMargin, leftMargin, 0, 0);
        container.setBorder(this.containerBorder);
        container.add((IFigure)figure);
        layout = new FlowLayout();
        layout.setHorizontal(false);
        container.setLayoutManager((LayoutManager)layout);
        return container;
    }

    @Override
    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        if (this.image != null) {
            this.image = null;
        }
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    @Override
    public void switchLayout(boolean horizontal) {
        boolean vertical = this.getModel() instanceof CompensationHandler || this.getModel() instanceof TerminationHandler;
        boolean horizontalLayout = ModelHelper.isHorizontalLayout(this.getModel());
        ((FlowLayout)this.getContentPane().getLayoutManager()).setHorizontal(horizontalLayout ? vertical : !vertical);
        int leftMargin = this.calcLeftMargin(horizontal);
        int topMargin = this.calcTopMargin(horizontal);
        this.getFigure().setBorder((Border)new MarginBorder(topMargin, leftMargin, 0, 0));
    }

    private int calcTopMargin(boolean horizontal) {
        int topMargin = 0;
        topMargin = horizontal ? 2 : (this.getParent() instanceof ScopeEditPart ? 42 : (this.getParent() instanceof InvokeEditPart ? 17 : 16));
        return topMargin;
    }

    private int calcLeftMargin(boolean horizontal) {
        int leftMargin = 0;
        if (horizontal && this.getParent() instanceof ProcessEditPart) {
            leftMargin = 30;
        }
        return leftMargin;
    }
}

