/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.BundledImageShape;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.internal.queries.BundledImageExtensionQuery;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorManager;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGFigure;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BundledImageFigure
extends SVGFigure {
    private static final String SVG_STROKE = "stroke";
    private static final String SVG_STROKE_WIDTH = "stroke-width";
    private static final String SVG_FILL = "fill";
    private static final String SVG_STOP_COLOR = "stop-color";
    private static final String SVG_STYLE_ATTRIBUTE_NAME = "style";
    private static final String SVG_STOP_LIGHTER_ID = "stop1";
    private static final String SVG_STOP_MAIN_ID = "stop2";
    private static final String SVG_GRADIENT_ELEMENT_ID = "elementWithGradient";
    private static final String SVG_BORDER_ID = "externalBorder";
    private static final String SVG_SHADOW_ELEMENT_ID = "shadow";
    private static final String BORDER_SIZE_ATTRIBUTE = "borderSizeAttribute";
    private static final String BORDER_SIZE_IDENTIFIER = "borderSizeIdentifier";
    private static final String BORDER_COLOR_ATTRIBUTE = "borderColorAttribute";
    private static final String BORDER_COLOR_IDENTIFIER = "borderColorIdentifier";
    private static final String COLOR_ATTRIBUTE = "colorAttribute";
    private static final String COLOR_IDENTIFIER = "colorIdentifier";
    private static final String SUB_ATTRIBUTE_IDENTIFIER = "subAttributeIdentifier";
    private String shapeName;
    private String shapeID;
    private String mainBorderColor;
    private int mainBorderSize;
    private String lighterBorderColor;
    private String lighterGradientColor;
    private String mainGradientColor;

    public static IFigure createImageFigure(BundledImage bundle) {
        BundledImageFigure fig = new BundledImageFigure();
        fig.refreshFigure(bundle);
        return fig;
    }

    public void setBorder(Border border) {
        if (BundledImageShape.getByName((String)this.shapeName) != null) {
            super.setBorder(null);
        } else {
            super.setBorder(border);
        }
    }

    private boolean updateShape(BundledImage bundledImage) {
        String newShapeName;
        boolean updated = false;
        if (!(bundledImage == null || bundledImage.getShape() == null || StringUtil.isEmpty((String)(newShapeName = bundledImage.getShape().getName())) || newShapeName.equals(this.getShapeName()) && (bundledImage.getProvidedShapeID() == null || bundledImage.getProvidedShapeID().equals(this.getShapeID())))) {
            if (newShapeName.equals(BundledImageShape.PROVIDED_SHAPE_LITERAL.getName())) {
                String providedShapeID = bundledImage.getProvidedShapeID();
                IConfigurationElement extension = this.getBundledImageExtensionQuery().getExtensionDefiningProvidedShapeID(providedShapeID);
                if (extension != null) {
                    String path = BundledImageExtensionQuery.getInstance().getImagePath(extension);
                    String imageFileURI = "platform:/plugin" + path;
                    this.setURI(imageFileURI, false);
                    this.setShapeName(BundledImageShape.PROVIDED_SHAPE_LITERAL.getName());
                    this.setShapeID(providedShapeID);
                }
            } else {
                this.setURI(BundledImageFigure.getImageFileURI(newShapeName), false);
                this.setShapeName(newShapeName);
            }
            updated = true;
        }
        return updated;
    }

    private boolean updateColors(BundledImage bundledImage, boolean force) {
        boolean updated = this.updateColorFields(bundledImage);
        updated = this.updateDocumentColors(force || updated, bundledImage);
        return updated;
    }

    private boolean updateBorderSize(BundledImage bundledImage, boolean force) {
        boolean updated = this.updateBorderSizeFields(bundledImage);
        updated = this.updateDocumentBorderSize(force || updated, bundledImage);
        return updated;
    }

    private boolean updateColorFields(BundledImage bundledImage) {
        RGBValues color = bundledImage.getColor();
        Color newLighterColor = ColorManager.getDefault().getLighterColor(color);
        RGBValues borderColor = bundledImage.getBorderColor();
        Color newBorderLighterColor = ColorManager.getDefault().getLighterColor(borderColor);
        String hexaColor = BundledImageFigure.getRGBValuesColorToHexa(color);
        String hexaLighterColor = BundledImageFigure.getColorToHexa(newLighterColor);
        String hexaBorderColor = BundledImageFigure.getRGBValuesColorToHexa(borderColor);
        String hexaLighterBorderColor = BundledImageFigure.getColorToHexa(newBorderLighterColor);
        boolean updated = false;
        if (hexaColor != null && !hexaColor.equals(this.getMainGradientColor())) {
            this.setMainGradientColor(hexaColor);
            updated = true;
        }
        if (hexaLighterColor != null && !hexaLighterColor.equals(this.getLighterGradientColor())) {
            this.setLighterGradientColor(hexaLighterColor);
            updated = true;
        }
        if (hexaBorderColor != null && !hexaBorderColor.equals(this.getMainBorderColor())) {
            this.setMainBorderColor(hexaBorderColor);
            updated = true;
        }
        if (hexaLighterBorderColor != null && !hexaLighterBorderColor.equals(this.getLighterBorderColor())) {
            this.setLighterBorderColor(hexaLighterBorderColor);
            updated = true;
        }
        return updated;
    }

    private boolean updateBorderSizeFields(BundledImage bundledImage) {
        int borderSize = bundledImage.getBorderSize();
        boolean updated = false;
        if (borderSize != this.getMainBorderSize()) {
            this.setMainBorderSize(borderSize);
            updated = true;
        }
        return updated;
    }

    private boolean updateDocumentColors(boolean needsUpdate, BundledImage bundledImage) {
        boolean updated = false;
        if (needsUpdate) {
            this.setURI(this.getURI(), false);
            Document document = this.getDocument();
            if (document != null && needsUpdate) {
                updated = this.isCustomBundledImageExtensionPoint(bundledImage) ? this.updateDocumentColorsNewExtensionPoint(needsUpdate, bundledImage, document) : this.updateDocumentColorsOldExtensionPoint(needsUpdate, bundledImage, document);
            }
        }
        return updated;
    }

    private boolean updateDocumentColorsNewExtensionPoint(boolean needsUpdate, BundledImage bundledImage, Document document) {
        boolean updated = false;
        Element gradientStep1 = this.findElementInDocument(bundledImage, document, COLOR_IDENTIFIER, SVG_STOP_LIGHTER_ID);
        if (gradientStep1 != null) {
            String subAttributeId;
            String customProperty = this.getCustomProperty(bundledImage, COLOR_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME);
            String gradientStep1Style = this.getAttributeValue(gradientStep1, bundledImage, COLOR_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME);
            if (this.canAttributeBeUpdated(gradientStep1Style, subAttributeId = this.getSubAttributeId(gradientStep1, bundledImage, COLOR_ATTRIBUTE), COLOR_ATTRIBUTE)) {
                gradientStep1.setAttribute(customProperty, BundledImageFigure.getNewStyle(gradientStep1Style, subAttributeId, this.getLighterGradientColor()));
                updated = true;
            }
        }
        updated = updated || this.updateDocumentSecondaryColorAndShadowBorder(document);
        Element elementWithGradient = this.findElementInDocument(bundledImage, document, BORDER_COLOR_IDENTIFIER, SVG_GRADIENT_ELEMENT_ID);
        if (elementWithGradient != null) {
            String subAttributeId;
            String customProperty = this.getCustomProperty(bundledImage, BORDER_COLOR_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME);
            String elementWithGradientStyle = this.getAttributeValue(elementWithGradient, bundledImage, BORDER_COLOR_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME);
            if (this.canAttributeBeUpdated(elementWithGradientStyle, subAttributeId = this.getSubAttributeId(elementWithGradient, bundledImage, BORDER_COLOR_ATTRIBUTE), BORDER_COLOR_ATTRIBUTE)) {
                elementWithGradient.setAttribute(customProperty, BundledImageFigure.getNewStyle(elementWithGradientStyle, subAttributeId, this.getMainBorderColor()));
                updated = true;
            }
        }
        return updated;
    }

    private boolean updateDocumentColorsOldExtensionPoint(boolean needsUpdate, BundledImage bundledImage, Document document) {
        String elementWithGradientStyle;
        String gradientStep1Style;
        boolean updated = false;
        Element gradientStep1 = this.findElementInDocument(bundledImage, document, COLOR_IDENTIFIER, SVG_STOP_LIGHTER_ID);
        if (gradientStep1 != null && this.canAttributeBeUpdated(gradientStep1Style = this.getAttributeValue(gradientStep1, bundledImage, COLOR_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME), SVG_STOP_COLOR, COLOR_ATTRIBUTE)) {
            gradientStep1.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(gradientStep1Style, SVG_STOP_COLOR, this.getLighterGradientColor()));
            updated = true;
        }
        updated = this.updateDocumentSecondaryColorAndShadowBorder(document) || updated;
        Element elementWithGradient = this.findElementInDocument(bundledImage, document, BORDER_COLOR_IDENTIFIER, SVG_GRADIENT_ELEMENT_ID);
        if (elementWithGradient != null && this.canAttributeBeUpdated(elementWithGradientStyle = this.getAttributeValue(elementWithGradient, bundledImage, BORDER_COLOR_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME), SVG_STROKE, BORDER_COLOR_ATTRIBUTE)) {
            elementWithGradient.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(elementWithGradientStyle, SVG_STROKE, this.getMainBorderColor()));
            updated = true;
        }
        return updated;
    }

    private boolean updateDocumentSecondaryColorAndShadowBorder(Document document) {
        String shadowStyle;
        Element shadow;
        String gradientStep2Style;
        boolean updated = false;
        Element gradientStep2 = document.getElementById(SVG_STOP_MAIN_ID);
        if (gradientStep2 != null && this.canAttributeBeUpdated(gradientStep2Style = gradientStep2.getAttribute(SVG_STYLE_ATTRIBUTE_NAME), SVG_STOP_COLOR, SVG_STYLE_ATTRIBUTE_NAME)) {
            gradientStep2.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(gradientStep2Style, SVG_STOP_COLOR, this.getMainGradientColor()));
            updated = true;
        }
        if ((shadow = document.getElementById(SVG_SHADOW_ELEMENT_ID)) != null && this.canAttributeBeUpdated(shadowStyle = shadow.getAttribute(SVG_STYLE_ATTRIBUTE_NAME), SVG_FILL, SVG_STYLE_ATTRIBUTE_NAME)) {
            shadow.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(shadowStyle, SVG_FILL, this.getLighterBorderColor()));
            updated = true;
        }
        return updated;
    }

    private boolean updateDocumentBorderSize(boolean needsUpdate, BundledImage bundledImage) {
        boolean updated = false;
        if (needsUpdate && this.getDocument() != null) {
            Document document = this.getDocument();
            if (this.isCustomBundledImageExtensionPoint(bundledImage)) {
                Element elementWithGradient = this.findElementInDocument(bundledImage, document, BORDER_SIZE_IDENTIFIER, SVG_BORDER_ID);
                if (elementWithGradient != null) {
                    String subAttributeId;
                    String customProperty = this.getCustomProperty(bundledImage, BORDER_SIZE_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME);
                    String elementWithGradientStyle = this.getAttributeValue(elementWithGradient, bundledImage, BORDER_SIZE_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME);
                    if (this.canAttributeBeUpdated(elementWithGradientStyle, subAttributeId = this.getSubAttributeId(elementWithGradient, bundledImage, BORDER_SIZE_ATTRIBUTE), BORDER_SIZE_ATTRIBUTE)) {
                        elementWithGradient.setAttribute(customProperty, BundledImageFigure.getNewStyle(elementWithGradientStyle, subAttributeId, Integer.toString(this.getMainBorderSize())));
                        updated = true;
                    }
                }
            } else {
                String svgStrokeWidth;
                String elementWithGradientStyle;
                Element elementWithGradient = this.findElementInDocument(bundledImage, document, BORDER_SIZE_IDENTIFIER, SVG_BORDER_ID);
                if (elementWithGradient != null && this.canAttributeBeUpdated(elementWithGradientStyle = this.getAttributeValue(elementWithGradient, bundledImage, BORDER_SIZE_ATTRIBUTE, SVG_STYLE_ATTRIBUTE_NAME), svgStrokeWidth = SVG_STROKE_WIDTH, BORDER_SIZE_ATTRIBUTE)) {
                    elementWithGradient.setAttribute(SVG_STYLE_ATTRIBUTE_NAME, BundledImageFigure.getNewStyle(elementWithGradientStyle, svgStrokeWidth, Integer.toString(this.getMainBorderSize())));
                    updated = true;
                }
            }
        }
        return updated;
    }

    private String getCustomProperty(BundledImage bundledImage, String propertyId, String defaultId) {
        String result = this.getBundledImageExtensionQuery().findParameterInExtension(this.getBundledImageExtensionQuery().getExtensionDefiningProvidedShapeID(bundledImage.getProvidedShapeID()), propertyId);
        if (result == null) {
            result = defaultId;
        }
        return result;
    }

    private boolean isCustomBundledImageExtensionPoint(BundledImage bundledImage) {
        if (bundledImage.getProvidedShapeID() == null) {
            return false;
        }
        String extensionPointUniqueIdentifier = this.getBundledImageExtensionQuery().getExtensionDefiningProvidedShapeID(bundledImage.getProvidedShapeID()).getDeclaringExtension().getExtensionPointUniqueIdentifier();
        return "org.eclipse.sirius.diagram.customBundledImageShape".equals(extensionPointUniqueIdentifier);
    }

    private Element findElementInDocument(BundledImage bundledImage, Document document, String elementId, String defaultId) {
        Element element = null;
        String findParameterInExtension = this.getBundledImageExtensionQuery().findParameterInExtension(this.getBundledImageExtensionQuery().getExtensionDefiningProvidedShapeID(bundledImage.getProvidedShapeID()), elementId);
        element = findParameterInExtension != null ? document.getElementById(findParameterInExtension) : document.getElementById(defaultId);
        return element;
    }

    private String getAttributeValue(Element documentElement, BundledImage bundledImage, String attributeId, String defaultId) {
        if (BundledImageShape.PROVIDED_SHAPE_LITERAL.equals((Object)bundledImage.getShape())) {
            return documentElement.getAttribute(this.getBundledImageExtensionQuery().findParameterInExtension(this.getBundledImageExtensionQuery().getExtensionDefiningProvidedShapeID(bundledImage.getProvidedShapeID()), attributeId));
        }
        return documentElement.getAttribute(defaultId);
    }

    private String getSubAttributeId(Element documentElement, BundledImage bundledImage, String parentAttributeId) {
        if (BundledImageShape.PROVIDED_SHAPE_LITERAL.equals((Object)bundledImage.getShape())) {
            IConfigurationElement extensionDefiningProvidedShapeID = this.getBundledImageExtensionQuery().getExtensionDefiningProvidedShapeID(bundledImage.getProvidedShapeID());
            if (this.isCustomBundledImageExtensionPoint(bundledImage) && extensionDefiningProvidedShapeID != null && extensionDefiningProvidedShapeID.getChildren(parentAttributeId).length > 0) {
                IConfigurationElement[] configurationElements = extensionDefiningProvidedShapeID.getChildren(parentAttributeId);
                return this.getBundledImageExtensionQuery().findParameterInExtension(configurationElements[0], SUB_ATTRIBUTE_IDENTIFIER);
            }
        }
        return null;
    }

    private BundledImageExtensionQuery getBundledImageExtensionQuery() {
        return BundledImageExtensionQuery.getInstance();
    }

    private static String getImageFileURI(String shapeName) {
        return MessageFormat.format("platform:/plugin/{0}/images/{1}.svg", DiagramUIPlugin.getPlugin().getSymbolicName(), shapeName);
    }

    private static String getRGBValuesColorToHexa(RGBValues color) {
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String getColorToHexa(Color color) {
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String getNewStyle(String actualStyle, String subAttributeId, String newValue) {
        if (subAttributeId == null) {
            String result = actualStyle.startsWith("#") ? "#" + newValue : newValue;
            return result;
        }
        int indexOfColorAttribute = actualStyle.indexOf(subAttributeId);
        String newStyle = SVG_STROKE_WIDTH.equals(subAttributeId) ? actualStyle.substring(0, indexOfColorAttribute + subAttributeId.length() + 1) : actualStyle.substring(0, indexOfColorAttribute + subAttributeId.length() + 2);
        newStyle = newStyle.concat(newValue);
        newStyle = newStyle.concat(actualStyle.substring(actualStyle.indexOf(";", indexOfColorAttribute), actualStyle.length()));
        return newStyle;
    }

    public void refreshFigure(BundledImage bundledImage) {
        if (bundledImage != null) {
            boolean updated = this.updateShape(bundledImage);
            updated = this.updateColors(bundledImage, updated) || updated;
            boolean bl = updated = this.updateBorderSize(bundledImage, updated) || updated;
            if (updated) {
                this.contentChanged();
            }
        } else {
            this.setURI(null);
        }
    }

    protected String getShapeName() {
        return this.shapeName;
    }

    protected void setShapeName(String shapeName) {
        this.shapeName = shapeName;
    }

    protected String getShapeID() {
        return this.shapeID;
    }

    protected void setShapeID(String shapeID) {
        this.shapeID = shapeID;
    }

    protected String getMainBorderColor() {
        return this.mainBorderColor;
    }

    protected void setMainBorderColor(String mainBorderColor) {
        this.mainBorderColor = mainBorderColor;
    }

    protected int getMainBorderSize() {
        return this.mainBorderSize;
    }

    protected void setMainBorderSize(int mainBorderSize) {
        this.mainBorderSize = mainBorderSize;
    }

    protected String getLighterBorderColor() {
        return this.lighterBorderColor;
    }

    protected void setLighterBorderColor(String lighterBorderColor) {
        this.lighterBorderColor = lighterBorderColor;
    }

    protected String getLighterGradientColor() {
        return this.lighterGradientColor;
    }

    protected void setLighterGradientColor(String lighterGradientColor) {
        this.lighterGradientColor = lighterGradientColor;
    }

    protected String getMainGradientColor() {
        return this.mainGradientColor;
    }

    protected void setMainGradientColor(String mainGradientColor) {
        this.mainGradientColor = mainGradientColor;
    }

    @Override
    protected String getDocumentKey() {
        StringBuffer result = new StringBuffer();
        result.append(super.getDocumentKey());
        result.append("|");
        result.append(this.shapeName);
        result.append("|");
        result.append(this.mainBorderColor);
        result.append("|");
        result.append(this.mainGradientColor);
        result.append("|");
        result.append(this.mainBorderSize);
        return result.toString();
    }

    private boolean canAttributeBeUpdated(String attributeValue, String svgProperty, String attributeToModify) {
        if (svgProperty != null) {
            boolean canBeUpdate;
            int indexOfProprAttribute = attributeValue.indexOf(svgProperty);
            boolean bl = canBeUpdate = indexOfProprAttribute >= 0;
            if (!canBeUpdate) {
                DiagramPlugin.getDefault().logWarning(MessageFormat.format(Messages.BundledImageShape_attributeAbsent, this.shapeID, attributeToModify));
            }
            return canBeUpdate;
        }
        return true;
    }
}

