/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoHelp;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.core.runtime.CoreException;

public class ArduinoPackage {
    private String name;
    private String maintainer;
    private String websiteURL;
    private String email;
    private ArduinoHelp help;
    private List<ArduinoPlatform> platforms;
    private List<ArduinoTool> tools;
    private Map<String, ArduinoPlatform> installedPlatforms;
    private Map<String, ArduinoTool> latestTools;

    public String getName() {
        return this.name;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getWebsiteURL() {
        return this.websiteURL;
    }

    public String getEmail() {
        return this.email;
    }

    public ArduinoHelp getHelp() {
        return this.help;
    }

    public Collection<ArduinoPlatform> getPlatforms() {
        return Collections.unmodifiableCollection(this.platforms);
    }

    void init() {
        for (ArduinoPlatform platform : this.platforms) {
            platform.init(this);
        }
        for (ArduinoTool tool : this.tools) {
            tool.init(this);
        }
    }

    void merge(ArduinoPackage other) {
        this.installedPlatforms = null;
        this.latestTools = null;
        if (other.platforms != null) {
            if (this.platforms != null) {
                this.platforms.addAll(other.platforms);
            } else {
                this.platforms = other.platforms;
            }
            for (ArduinoPlatform platform : other.platforms) {
                platform.init(this);
            }
        }
        if (other.tools != null) {
            if (this.tools != null) {
                this.tools.addAll(other.tools);
            } else {
                this.tools = other.tools;
            }
            for (ArduinoTool tool : other.tools) {
                tool.init(this);
            }
        }
    }

    public ArduinoPlatform getPlatform(String architecture, String version) {
        if (this.platforms != null) {
            for (ArduinoPlatform plat : this.platforms) {
                if (!plat.getArchitecture().equals(architecture) || !plat.getVersion().equals(version)) continue;
                return plat;
            }
        }
        return null;
    }

    public Path getInstallPath() {
        return ArduinoPreferences.getArduinoHome().resolve("packages").resolve(this.getName());
    }

    private synchronized void initInstalledPlatforms() throws CoreException {
        if (this.installedPlatforms == null) {
            this.installedPlatforms = new HashMap<String, ArduinoPlatform>();
            Path hardware = this.getInstallPath().resolve("hardware");
            if (Files.isDirectory(hardware, new LinkOption[0])) {
                for (ArduinoPlatform platform : this.platforms) {
                    ArduinoPlatform current;
                    String arch = platform.getArchitecture();
                    String version = platform.getVersion();
                    Path platPath = hardware.resolve(arch).resolve(version);
                    if (!Files.exists(platPath, new LinkOption[0]) || (current = this.installedPlatforms.get(arch)) != null && ArduinoManager.compareVersions(version, current.getVersion()) <= 0) continue;
                    this.installedPlatforms.put(arch, platform);
                }
            }
        }
    }

    public Collection<ArduinoPlatform> getInstalledPlatforms() throws CoreException {
        this.initInstalledPlatforms();
        return this.installedPlatforms.values();
    }

    public ArduinoPlatform getInstalledPlatform(String architecture) throws CoreException {
        if (architecture == null) {
            return null;
        }
        this.initInstalledPlatforms();
        return this.installedPlatforms.get(architecture);
    }

    void platformInstalled(ArduinoPlatform platform) {
        this.installedPlatforms.put(platform.getArchitecture(), platform);
    }

    void platformUninstalled(ArduinoPlatform platform) {
        this.installedPlatforms.remove(platform.getArchitecture());
    }

    public Collection<ArduinoPlatform> getAvailablePlatforms() throws CoreException {
        this.initInstalledPlatforms();
        HashMap<String, ArduinoPlatform> platformMap = new HashMap<String, ArduinoPlatform>();
        for (ArduinoPlatform platform : this.platforms) {
            ArduinoPlatform p;
            if (this.installedPlatforms.containsKey(platform.getArchitecture()) || (p = (ArduinoPlatform)platformMap.get(platform.getArchitecture())) != null && ArduinoManager.compareVersions(platform.getVersion(), p.getVersion()) <= 0) continue;
            platformMap.put(platform.getArchitecture(), platform);
        }
        return platformMap.values();
    }

    public Collection<ArduinoPlatform> getPlatformUpdates() throws CoreException {
        this.initInstalledPlatforms();
        HashMap<String, ArduinoPlatform> platformMap = new HashMap<String, ArduinoPlatform>();
        for (ArduinoPlatform platform : this.platforms) {
            ArduinoPlatform current;
            ArduinoPlatform installed = this.installedPlatforms.get(platform.getArchitecture());
            if (installed == null || ArduinoManager.compareVersions(platform.getVersion(), installed.getVersion()) <= 0 || (current = (ArduinoPlatform)platformMap.get(platform.getArchitecture())) != null && ArduinoManager.compareVersions(platform.getVersion(), current.getVersion()) <= 0) continue;
            platformMap.put(platform.getArchitecture(), platform);
        }
        return platformMap.values();
    }

    public List<ArduinoTool> getTools() {
        return this.tools;
    }

    public ArduinoTool getTool(String toolName, String version) {
        for (ArduinoTool tool : this.tools) {
            if (!tool.getName().equals(toolName) || !tool.getVersion().equals(version)) continue;
            return tool;
        }
        return null;
    }

    private void initLatestTools() {
        if (this.latestTools == null) {
            this.latestTools = new HashMap<String, ArduinoTool>();
            for (ArduinoTool tool : this.tools) {
                ArduinoTool current = this.latestTools.get(tool.getName());
                if (current != null && ArduinoManager.compareVersions(tool.getVersion(), current.getVersion()) <= 0) continue;
                this.latestTools.put(tool.getName(), tool);
            }
        }
    }

    public ArduinoTool getLatestTool(String toolName) {
        this.initLatestTools();
        return this.latestTools.get(toolName);
    }

    public Collection<ArduinoTool> getLatestTools() {
        this.initLatestTools();
        return this.latestTools.values();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArduinoPackage) {
            return ((ArduinoPackage)obj).getName().equals(this.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

