/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.DefaultUriSource;
import org.junit.platform.engine.support.descriptor.DirectorySource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.ResourceUtils;

@API(status=API.Status.STABLE, since="1.0")
public interface UriSource
extends TestSource {
    public URI getUri();

    public static UriSource from(URI uri) {
        Preconditions.notNull((Object)uri, (String)"URI must not be null");
        try {
            URI uriWithoutQuery = ResourceUtils.stripQueryComponent(uri);
            Path path = Paths.get(uriWithoutQuery);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                return FileSource.from(path.toFile(), FilePosition.fromQuery(uri.getQuery()).orElse(null));
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                return DirectorySource.from(path.toFile());
            }
        }
        catch (RuntimeException ex) {
            LoggerFactory.getLogger(UriSource.class).debug((Throwable)ex, () -> String.format("The supplied URI [%s] is not path-based. Falling back to default UriSource implementation.", uri));
        }
        return new DefaultUriSource(uri);
    }
}

