/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.participant;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationContext;
import org.eclipse.xtext.ui.refactoring2.participant.ResourceRelocationProcessor;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XtextMoveResourceParticipant
extends MoveParticipant
implements ISharableParticipant {
    @Inject
    private ResourceRelocationProcessor processor;
    private Change change;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        try {
            this.change = this.processor.createChange(this.getName(), ResourceRelocationContext.ChangeType.MOVE, pm);
            return this.processor.getIssues().getRefactoringStatus();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.change;
    }

    public String getName() {
        return "Xtext move resource participant";
    }

    protected boolean initialize(Object element) {
        boolean _xblockexpression = false;
        this.addElement(element, (RefactoringArguments)this.getArguments());
        _xblockexpression = true;
        return _xblockexpression;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        Object destination;
        if (arguments instanceof MoveArguments && element instanceof IResource && ((destination = ((MoveArguments)arguments).getDestination()) instanceof IFolder || destination instanceof IProject)) {
            IFile _switchResult = null;
            boolean _matched = false;
            if (destination instanceof IFolder) {
                _matched = true;
                _switchResult = ((IFolder)destination).getFile(((IResource)element).getName());
            }
            if (!_matched && destination instanceof IProject) {
                _matched = true;
                _switchResult = ((IProject)destination).getFile(((IResource)element).getName());
            }
            IFile destinationFile = _switchResult;
            this.processor.addChangedResource((IResource)element, ((IResource)element).getFullPath(), destinationFile.getFullPath());
        }
    }
}

