/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.internal.Activator;
import org.eclipse.xtext.ui.refactoring.impl.Messages;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringType;
import org.eclipse.xtext.ui.refactoring.ui.RenameLinkedMode;
import org.eclipse.xtext.ui.refactoring.ui.RenameRefactoringController;

public class RenameRefactoringPopup
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    private static final int HAO = 10;
    private static final int HAW = 8;
    private static final int HAH = 10;
    private static final int GAP = 2;
    private XtextEditor editor;
    private RenameRefactoringController controller;
    private Region region;
    private static final int WIDGET_PRIORITY = 1000;
    private static boolean MAC = Util.isMac();
    private boolean delayJobFinished = false;
    private static final int POPUP_VISIBILITY_DELAY = 300;
    private String openDialogBinding;
    private Shell popup;
    private GridLayout popupLayout;
    private ToolBar toolBar;
    private Image menuImage;
    private MenuManager menuManager;
    private boolean iSMenuUp = false;
    private RenameLinkedMode renameLinkedMode;

    public RenameRefactoringPopup(XtextEditor editor, RenameRefactoringController controller, RenameLinkedMode renameLinkedMode) {
        this.editor = editor;
        this.controller = controller;
        this.renameLinkedMode = renameLinkedMode;
    }

    protected void updateVisibility() {
        if (this.popup != null && !this.popup.isDisposed() && this.delayJobFinished) {
            boolean visible = false;
            if (this.renameLinkedMode.isCaretInLinkedPosition()) {
                StyledText textWidget = this.editor.getInternalSourceViewer().getTextWidget();
                Rectangle eArea = Geometry.toDisplay((Control)textWidget, (Rectangle)textWidget.getClientArea());
                Rectangle pBounds = this.popup.getBounds();
                pBounds.x -= 2;
                pBounds.y -= 2;
                pBounds.width += 4;
                pBounds.height += 4;
                if (eArea.intersects(pBounds)) {
                    visible = true;
                }
            }
            if (visible && !this.popup.isVisible()) {
                ISourceViewer viewer = this.editor.getInternalSourceViewer();
                if (viewer instanceof IWidgetTokenOwnerExtension) {
                    IWidgetTokenOwnerExtension widgetTokenOwnerExtension = (IWidgetTokenOwnerExtension)viewer;
                    widgetTokenOwnerExtension.requestWidgetToken((IWidgetTokenKeeper)this, 1000);
                }
            } else if (!visible && this.popup.isVisible()) {
                this.releaseWidgetToken();
            }
            this.popup.setVisible(visible);
        }
    }

    protected void releaseWidgetToken() {
        ISourceViewer viewer = this.editor.getInternalSourceViewer();
        if (viewer instanceof IWidgetTokenOwner) {
            IWidgetTokenOwner widgetTokenOwner = (IWidgetTokenOwner)viewer;
            widgetTokenOwner.releaseWidgetToken((IWidgetTokenKeeper)this);
        }
    }

    public void open() {
        this.openDialogBinding = RenameRefactoringPopup.getOpenDialogBinding();
        Shell workbenchShell = this.editor.getSite().getShell();
        final Display display = workbenchShell.getDisplay();
        this.popup = new Shell(workbenchShell, 16396);
        this.popupLayout = new GridLayout(2, false);
        this.popupLayout.marginWidth = 1;
        this.popupLayout.marginHeight = 1;
        this.popupLayout.marginLeft = 4;
        this.popupLayout.horizontalSpacing = 0;
        this.popup.setLayout((Layout)this.popupLayout);
        this.createContent((Composite)this.popup);
        this.updatePopupLocation();
        new PopupVisibilityManager().start();
        this.popup.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                if (RenameRefactoringPopup.this.iSMenuUp) {
                    return;
                }
                final Shell editorShell = RenameRefactoringPopup.this.editor.getSite().getShell();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell activeShell = display.getActiveShell();
                        if (activeShell != editorShell) {
                            RenameRefactoringPopup.this.controller.cancelLinkedMode();
                        }
                    }
                });
            }
        });
        if (!MAC) {
            this.popup.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent pe) {
                    pe.gc.drawPolygon(RenameRefactoringPopup.this.getPolygon(true));
                }
            });
        }
        UIJob delayJob = new UIJob(display, "Delayed RenameInformationPopup"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RenameRefactoringPopup.this.delayJobFinished = true;
                if (RenameRefactoringPopup.this.popup != null && !RenameRefactoringPopup.this.popup.isDisposed()) {
                    RenameRefactoringPopup.this.updateVisibility();
                }
                return Status.OK_STATUS;
            }
        };
        delayJob.setSystem(true);
        delayJob.setPriority(10);
        delayJob.schedule(300L);
    }

    protected void createContent(Composite parent) {
        Color background;
        Display display = parent.getDisplay();
        ColorRegistry registry = JFaceResources.getColorRegistry();
        Color foreground = registry.get("org.eclipse.ui.workbench.HOVER_FOREGROUND");
        if (foreground == null) {
            foreground = display.getSystemColor(28);
        }
        if ((background = registry.get("org.eclipse.ui.workbench.HOVER_BACKGROUND")) == null) {
            background = display.getSystemColor(29);
        }
        StyledText hint = new StyledText((Composite)this.popup, 12);
        String enterKeyName = RenameRefactoringPopup.getEnterBinding();
        String hintTemplate = "Enter new name, press {0} to refactor";
        hint.setText(Messages.format(hintTemplate, enterKeyName));
        hint.setForeground(foreground);
        hint.setStyleRange(new StyleRange(hintTemplate.indexOf("{0}"), enterKeyName.length(), null, null, 1));
        hint.setEnabled(false);
        this.addViewMenu(parent);
        RenameRefactoringPopup.recursiveSetBackgroundColor((Control)parent, background);
    }

    protected static void recursiveSetBackgroundColor(Control control, Color color) {
        control.setBackground(color);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                RenameRefactoringPopup.recursiveSetBackgroundColor(children[i], color);
                ++i;
            }
        }
    }

    protected ToolBar addViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        ToolItem menuButton = new ToolItem(this.toolBar, 8, 0);
        this.menuImage = Activator.getImageDescriptor("icons/elcl16/view_menu.gif").createImage();
        menuButton.setImage(this.menuImage);
        menuButton.setToolTipText("Menu");
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                RenameRefactoringPopup.this.showMenu(RenameRefactoringPopup.this.toolBar);
            }
        });
        menuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RenameRefactoringPopup.this.showMenu(RenameRefactoringPopup.this.toolBar);
            }
        });
        this.toolBar.pack();
        return this.toolBar;
    }

    protected void showMenu(ToolBar toolBar) {
        Menu menu = this.getMenuManager().createContextMenu((Control)toolBar);
        menu.setLocation(toolBar.toDisplay(0, toolBar.getSize().y));
        this.iSMenuUp = true;
        menu.setVisible(true);
    }

    protected MenuManager getMenuManager() {
        if (this.menuManager != null) {
            return this.menuManager;
        }
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToHide(IMenuManager manager) {
                RenameRefactoringPopup.this.iSMenuUp = false;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean canRefactor = RenameRefactoringPopup.this.renameLinkedMode.isCurrentNameValid();
                Action refactorAction = new Action("Rename..."){

                    public void run() {
                        RenameRefactoringPopup.this.activateEditor();
                        RenameRefactoringPopup.this.controller.startRefactoring(RefactoringType.REFACTORING_DIRECT);
                    }
                };
                refactorAction.setAccelerator(13);
                refactorAction.setEnabled(canRefactor);
                manager.add((IAction)refactorAction);
                Action previewAction = new Action("Preview..."){

                    public void run() {
                        RenameRefactoringPopup.this.activateEditor();
                        RenameRefactoringPopup.this.controller.startRefactoring(RefactoringType.REFACTORING_PREVIEW);
                    }
                };
                previewAction.setAccelerator(262157);
                previewAction.setEnabled(canRefactor);
                manager.add((IAction)previewAction);
                Action openDialogAction = new Action("Open Rename Dialog...\t" + RenameRefactoringPopup.this.openDialogBinding){

                    public void run() {
                        RenameRefactoringPopup.this.activateEditor();
                        RenameRefactoringPopup.this.controller.startRefactoring(RefactoringType.REFACTORING_DIALOG);
                    }
                };
                manager.add((IAction)openDialogAction);
            }
        });
        return this.menuManager;
    }

    protected static String getEnterBinding() {
        return KeyStroke.getInstance((int)KeyLookupFactory.getDefault().formalKeyLookup("CR")).format();
    }

    protected Point computePopupLocation() {
        if (this.popup == null || this.popup.isDisposed()) {
            return null;
        }
        LinkedPosition position = this.renameLinkedMode.getCurrentLinkedPosition();
        if (position == null) {
            return null;
        }
        ISourceViewer viewer = this.editor.getInternalSourceViewer();
        ITextViewerExtension5 viewer5 = (ITextViewerExtension5)viewer;
        int widgetOffset = viewer5.modelOffset2WidgetOffset(position.offset);
        StyledText textWidget = viewer.getTextWidget();
        Point pos = textWidget.getLocationAtOffset(widgetOffset);
        Point pSize = this.getExtent();
        pSize.y += 11;
        pos.x -= 10;
        pos.y += textWidget.getLineHeight(widgetOffset);
        Point dPos = textWidget.toDisplay(pos);
        Rectangle displayBounds = textWidget.getDisplay().getClientArea();
        Rectangle dPopupRect = Geometry.createRectangle((Point)dPos, (Point)pSize);
        Geometry.moveInside((Rectangle)dPopupRect, (Rectangle)displayBounds);
        return new Point(dPopupRect.x, dPopupRect.y);
    }

    protected Point getExtent() {
        Point e = this.popup.getSize();
        e.y -= 10;
        return e;
    }

    protected void updatePopupLocation() {
        this.packPopup();
        Point loc = this.computePopupLocation();
        if (loc != null && !loc.equals((Object)this.popup.getLocation())) {
            this.popup.setLocation(loc);
        }
    }

    protected void packPopup() {
        this.popupLayout.marginTop = 10;
        this.popupLayout.marginBottom = 0;
        this.popup.pack();
        Region oldRegion = this.region;
        this.region = new Region();
        this.region.add(this.getPolygon(false));
        this.popup.setRegion(this.region);
        Rectangle bounds = this.region.getBounds();
        this.popup.setSize(bounds.width, bounds.height + 2);
        if (oldRegion != null) {
            oldRegion.dispose();
        }
    }

    protected int[] getPolygon(boolean border) {
        Point e = this.getExtent();
        int b = border ? 1 : 0;
        boolean isRTL = (this.popup.getStyle() & 0x4000000) != 0;
        int ha1 = isRTL ? e.x - 10 : 18;
        int ha2 = isRTL ? e.x - 10 - 4 : 14;
        int ha3 = isRTL ? e.x - 10 - 8 : 10;
        int[] nArray = new int[16];
        nArray[1] = 10;
        nArray[2] = ha3 + b;
        nArray[3] = 10;
        nArray[4] = ha2;
        nArray[5] = b;
        nArray[6] = ha1 - b;
        nArray[7] = 10;
        nArray[8] = e.x - b;
        nArray[9] = 10;
        nArray[10] = e.x - b;
        nArray[11] = e.y + 10 - b;
        nArray[13] = e.y + 10 - b;
        nArray[15] = 10;
        int[] poly = nArray;
        return poly;
    }

    protected static String getOpenDialogBinding() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService == null) {
            return "";
        }
        String binding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.xtext.ui.refactoring.RenameElement");
        return binding == null ? "" : binding;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        if (this.toolBar != null && !this.toolBar.isDisposed()) {
            this.showMenu(this.toolBar);
        }
        return true;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        return false;
    }

    public boolean ownsFocusShell() {
        if (this.iSMenuUp) {
            return true;
        }
        if (this.popup == null || this.popup.isDisposed()) {
            return false;
        }
        Shell activeShell = this.popup.getDisplay().getActiveShell();
        return this.popup == activeShell;
    }

    protected void activateEditor() {
        this.editor.getSite().getShell().setActive();
    }

    public void close() {
        if (this.popup != null) {
            if (!this.popup.isDisposed()) {
                this.popup.close();
            }
            this.popup = null;
        }
        this.releaseWidgetToken();
        if (this.region != null && !this.region.isDisposed()) {
            this.region.dispose();
        }
    }

    protected class PopupVisibilityManager
    implements IPartListener2,
    ControlListener,
    MouseListener,
    KeyListener,
    IViewportListener {
        protected PopupVisibilityManager() {
        }

        protected void start() {
            RenameRefactoringPopup.this.editor.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
            final ISourceViewer viewer = RenameRefactoringPopup.this.editor.getInternalSourceViewer();
            final StyledText textWidget = viewer.getTextWidget();
            textWidget.addControlListener((ControlListener)this);
            textWidget.addMouseListener((MouseListener)this);
            textWidget.addKeyListener((KeyListener)this);
            RenameRefactoringPopup.this.editor.getSite().getShell().addControlListener((ControlListener)this);
            viewer.addViewportListener((IViewportListener)this);
            RenameRefactoringPopup.this.popup.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    RenameRefactoringPopup.this.editor.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)PopupVisibilityManager.this);
                    if (!textWidget.isDisposed()) {
                        textWidget.removeControlListener((ControlListener)PopupVisibilityManager.this);
                        textWidget.removeMouseListener((MouseListener)PopupVisibilityManager.this);
                        textWidget.removeKeyListener((KeyListener)PopupVisibilityManager.this);
                    }
                    RenameRefactoringPopup.this.editor.getSite().getShell().removeControlListener((ControlListener)PopupVisibilityManager.this);
                    viewer.removeViewportListener((IViewportListener)PopupVisibilityManager.this);
                    if (RenameRefactoringPopup.this.menuImage != null) {
                        RenameRefactoringPopup.this.menuImage.dispose();
                        RenameRefactoringPopup.this.menuImage = null;
                    }
                    if (RenameRefactoringPopup.this.menuManager != null) {
                        RenameRefactoringPopup.this.menuManager.dispose();
                        RenameRefactoringPopup.this.menuManager = null;
                    }
                }
            });
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart fPart = RenameRefactoringPopup.this.editor.getEditorSite().getPart();
            if (partRef.getPart(false) == fPart) {
                RenameRefactoringPopup.this.updateVisibility();
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart fPart = RenameRefactoringPopup.this.editor.getEditorSite().getPart();
            if (RenameRefactoringPopup.this.popup != null && !RenameRefactoringPopup.this.popup.isDisposed() && partRef.getPart(false) == fPart) {
                RenameRefactoringPopup.this.popup.setVisible(false);
            }
        }

        public void viewportChanged(int verticalOffset) {
            RenameRefactoringPopup.this.updatePopupLocation();
            RenameRefactoringPopup.this.updateVisibility();
        }

        public void mouseUp(MouseEvent e) {
            RenameRefactoringPopup.this.updatePopupLocation();
            RenameRefactoringPopup.this.updateVisibility();
        }

        public void keyPressed(KeyEvent e) {
            RenameRefactoringPopup.this.updatePopupLocation();
            RenameRefactoringPopup.this.updateVisibility();
        }

        public void controlMoved(ControlEvent e) {
            RenameRefactoringPopup.this.updatePopupLocation();
            RenameRefactoringPopup.this.updateVisibility();
        }

        public void controlResized(ControlEvent e) {
            RenameRefactoringPopup.this.updatePopupLocation();
            RenameRefactoringPopup.this.updateVisibility();
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

