/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.xtext.ide.editor.hierarchy.ICallHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyRoot;
import org.eclipse.xtext.ide.editor.navigation.INavigatable;
import org.eclipse.xtext.ui.editor.hierarchy.AbstractHierarchyViewPart;
import org.eclipse.xtext.ui.editor.hierarchy.HierarchyTreeContentProvider;
import org.eclipse.xtext.ui.editor.hierarchy.RefreshHierarchyAction;
import org.eclipse.xtext.ui.editor.hierarchy.SetHierarchyTypeAction;
import org.eclipse.xtext.ui.editor.navigation.NavigationService;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class AbstractCallHierarchyViewPart
extends AbstractHierarchyViewPart
implements ISelectionChangedListener {
    @Inject
    private NavigationService navigationService;
    private TableViewer locationViewer;
    private TreeViewer callHierarchyViewer;
    private final RefreshHierarchyAction refreshAction = new RefreshHierarchyAction(this);
    private final List<SetHierarchyTypeAction> setHierarchyTypeActions = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new SetHierarchyTypeAction[]{new SetHierarchyTypeAction(ICallHierarchyBuilder.CallHierarchyType.CALLER, this), new SetHierarchyTypeAction(ICallHierarchyBuilder.CallHierarchyType.CALLEE, this)}));

    protected ICallHierarchyBuilder getCallHierarchyBuilder() {
        return this.getBuilder(ICallHierarchyBuilder.class);
    }

    public void setCallHierarchyType(ICallHierarchyBuilder.CallHierarchyType hierarchyType) {
        ICallHierarchyBuilder _callHierarchyBuilder = this.getCallHierarchyBuilder();
        if (_callHierarchyBuilder != null) {
            _callHierarchyBuilder.setHierarchyType(hierarchyType);
        }
        NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
        this.refresh((IProgressMonitor)_nullProgressMonitor);
    }

    @Override
    public void refresh(IProgressMonitor monitor) {
        ICallHierarchyBuilder _callHierarchyBuilder = this.getCallHierarchyBuilder();
        ICallHierarchyBuilder.CallHierarchyType _hierarchyType = null;
        if (_callHierarchyBuilder != null) {
            _hierarchyType = _callHierarchyBuilder.getHierarchyType();
        }
        ICallHierarchyBuilder.CallHierarchyType hierarchyType = _hierarchyType;
        for (SetHierarchyTypeAction setHierarchyTypeAction : this.setHierarchyTypeActions) {
            ICallHierarchyBuilder.CallHierarchyType _hierarchyType_1 = setHierarchyTypeAction.getHierarchyType();
            boolean _tripleEquals = hierarchyType == _hierarchyType_1;
            setHierarchyTypeAction.setChecked(_tripleEquals);
        }
        super.refresh(monitor);
    }

    @Override
    public void setRoot(IHierarchyRoot root) {
        this.callHierarchyViewer.setInput((Object)root);
        this.setFocus();
    }

    public void createPartControl(Composite parent) {
        Composite layout = this.createLayout(parent);
        this.callHierarchyViewer = this.createCallHierarchyViewer(layout);
        this.locationViewer = this.createLocationViewer(layout);
        this.navigationService.installNavigationSupport((StructuredViewer)this.locationViewer);
        this.navigationService.installNavigationSupport((StructuredViewer)this.callHierarchyViewer);
        this.callHierarchyViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.addActions(this.getViewSite().getActionBars().getToolBarManager());
    }

    protected void addActions(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.refreshAction);
        for (SetHierarchyTypeAction setHierarchyTypeAction : this.setHierarchyTypeActions) {
            toolBarManager.add((IAction)setHierarchyTypeAction);
        }
    }

    protected Composite createLayout(Composite parent) {
        return new SashForm(parent, 0);
    }

    protected TreeViewer createCallHierarchyViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent);
        Control _control = treeViewer.getControl();
        GridData _gridData = new GridData(1808);
        _control.setLayoutData((Object)_gridData);
        treeViewer.setUseHashlookup(true);
        treeViewer.setAutoExpandLevel(2);
        treeViewer.setLabelProvider(this.createHierarchyLabelProvider());
        treeViewer.setContentProvider(this.createHierarchyContentProvider());
        return treeViewer;
    }

    protected IContentProvider createHierarchyContentProvider() {
        return new HierarchyTreeContentProvider(this);
    }

    protected abstract IBaseLabelProvider createHierarchyLabelProvider();

    protected TableViewer createLocationViewer(Composite parent) {
        TableViewer locationViewer = new TableViewer(parent);
        ArrayContentProvider _arrayContentProvider = new ArrayContentProvider();
        locationViewer.setContentProvider((IContentProvider)_arrayContentProvider);
        locationViewer.setLabelProvider(this.createLocationLabelProvider());
        TableLayout layout = new TableLayout();
        Table _table = locationViewer.getTable();
        _table.setLayout((Layout)layout);
        Table _table_1 = locationViewer.getTable();
        _table_1.setHeaderVisible(true);
        Consumer<Pair> _function = it -> {
            layout.addColumnData((ColumnLayoutData)((Pair)it.getValue()).getValue());
            this.createColumn(locationViewer.getTable(), (Pair<String, ColumnLayoutData>)((Pair)it.getValue()), (Integer)it.getKey());
        };
        IterableExtensions.indexed((Iterable)((Iterable)Conversions.doWrapArray(this.getLocationColumnDescriptions()))).forEach(_function);
        return locationViewer;
    }

    protected Pair<String, ColumnLayoutData>[] getLocationColumnDescriptions() {
        ColumnWeightData _columnWeightData = new ColumnWeightData(60);
        Pair _mappedTo = Pair.of((Object)"Line", (Object)_columnWeightData);
        ColumnWeightData _columnWeightData_1 = new ColumnWeightData(300);
        Pair _mappedTo_1 = Pair.of((Object)"Call", (Object)_columnWeightData_1);
        return new Pair[]{_mappedTo, _mappedTo_1};
    }

    protected void createColumn(Table table, Pair<String, ColumnLayoutData> columnDescription, int index) {
        TableColumn column = new TableColumn(table, 0, index);
        column.setResizable(((ColumnLayoutData)columnDescription.getValue()).resizable);
        column.setText((String)columnDescription.getKey());
    }

    protected abstract IBaseLabelProvider createLocationLabelProvider();

    public void setFocus() {
        this.callHierarchyViewer.getControl().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        boolean _tripleEquals;
        ISelectionProvider _selectionProvider = event.getSelectionProvider();
        boolean bl = _tripleEquals = _selectionProvider == this.callHierarchyViewer;
        if (_tripleEquals) {
            IHierarchyNode callHierarchyNode = this.getSelectedNode(event.getSelection());
            this.onCallHierarchyNodeChanged(callHierarchyNode);
        }
    }

    protected void onCallHierarchyNodeChanged(IHierarchyNode node) {
        Collection _elvis = null;
        Collection _references = null;
        if (node != null) {
            _references = node.getReferences();
        }
        if (_references != null) {
            _elvis = _references;
        } else {
            List _emptyList = CollectionLiterals.emptyList();
            _elvis = _emptyList;
        }
        this.locationViewer.setInput((Object)_elvis);
        this.navigationService.open((INavigatable)node);
        this.setFocus();
    }
}

