/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.util.surround.ISurroundProcessor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutSurroundSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigLayoutSurroundProcessor
implements ISurroundProcessor<ContainerInfo, ComponentInfo> {
    public static final Object INSTANCE = new MigLayoutSurroundProcessor();

    private MigLayoutSurroundProcessor() {
    }

    public boolean filter(ContainerInfo sourceContainer, ContainerInfo targetContainer) throws Exception {
        String targetClassName = targetContainer.getDescription().getComponentClass().getName();
        boolean isJPanel = targetClassName.equals("javax.swing.JPanel");
        return sourceContainer.hasLayout() && sourceContainer.getLayout() instanceof MigLayoutInfo && isJPanel;
    }

    public void move(ContainerInfo sourceContainer, ContainerInfo targetContainer, List<ComponentInfo> components) throws Exception {
        MigLayoutInfo targetLayout = (MigLayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)targetContainer.getEditor(), (String)"net.miginfocom.swing.MigLayout", (CreationSupport)new ConstructorCreationSupport());
        targetContainer.setLayout((LayoutInfo)targetLayout);
        Rectangle targetBounds = (Rectangle)targetContainer.getArbitraryValue((Object)"SurroundSupport_CELLS");
        MigLayoutInfo sourceLayout = (MigLayoutInfo)sourceContainer.getLayout();
        ArrayList targetColumns = Lists.newArrayList();
        int columnIndex = targetBounds.x;
        while (columnIndex < targetBounds.right()) {
            MigColumnInfo sourceColumn = sourceLayout.getColumns().get(columnIndex);
            MigColumnInfo targetColumn = new MigColumnInfo(targetLayout);
            targetColumn.setString(sourceColumn.getString(false));
            targetColumns.add(targetColumn);
            ++columnIndex;
        }
        targetLayout.setColumns(targetColumns);
        ArrayList targetRows = Lists.newArrayList();
        int rowIndex = targetBounds.y;
        while (rowIndex < targetBounds.bottom()) {
            MigRowInfo sourceRow = sourceLayout.getRows().get(rowIndex);
            MigRowInfo targetRow = new MigRowInfo(targetLayout);
            targetRow.setString(sourceRow.getString(false));
            targetRows.add(targetRow);
            ++rowIndex;
        }
        targetLayout.setRows(targetRows);
        Point locationOffset = targetBounds.getLocation().getNegated();
        for (ComponentInfo component : components) {
            CellConstraintsSupport oldConstraints = MigLayoutInfo.getConstraints(component);
            Rectangle cells = MigLayoutSurroundSupport.getCells(component);
            cells = cells.getTranslated(locationOffset);
            targetLayout.command_MOVE(component, cells.x, false, cells.y, false);
            CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(component);
            constraints.setWidth(oldConstraints.getWidth());
            constraints.setHeight(oldConstraints.getHeight());
            constraints.setHorizontalAlignment(oldConstraints.getHorizontalAlignment());
            constraints.setVerticalAlignment(oldConstraints.getVerticalAlignment());
            constraints.write();
        }
    }
}

