/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.ui.contentproviders;

import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.core.databinding.ui.editor.DialogFieldUiContentProvider;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.dialogfields.IListAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.ListDialogField;
import org.eclipse.wb.internal.rcp.databinding.xwt.Activator;
import org.eclipse.wb.internal.rcp.databinding.xwt.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.xwt.Messages;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.ValidationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationUiContentProvider
extends DialogFieldUiContentProvider {
    private static final Image CLASS_IMAGE = Activator.getImage("class_obj.gif");
    private static final Image ERROR_IMAGE = Activator.getImage("error_obj.gif");
    private final ListDialogField m_dialogField;
    private final DatabindingsProvider m_provider;
    private final ValidationInfo m_validator;
    private final IListAdapter m_listAdapter = new IListAdapter(){

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 0) {
                ValidationUiContentProvider.this.handleAdd();
            }
        }
    };
    private final IDialogFieldListener m_changeListener = new IDialogFieldListener(){

        public void dialogFieldChanged(DialogField field) {
            ValidationUiContentProvider.this.calculateFinish();
        }
    };

    public ValidationUiContentProvider(DatabindingsProvider provider, ValidationInfo validator) {
        this.m_provider = provider;
        this.m_validator = validator;
        this.m_dialogField = new ListDialogField(this.m_listAdapter, new String[]{Messages.ValidationUiContentProvider_addButton, Messages.ValidationUiContentProvider_removeButton}, (ILabelProvider)new LabelProvider());
        this.m_dialogField.setRemoveButtonIndex(1);
        this.m_dialogField.setLabelText(Messages.ValidationUiContentProvider_title);
    }

    public DialogField getDialogField() {
        return this.m_dialogField;
    }

    public void createContent(Composite parent, int columns) {
        super.createContent(parent, columns);
        GridData data = (GridData)this.m_dialogField.getListControl(null).getLayoutData();
        data.verticalAlignment = 1;
        data.grabExcessVerticalSpace = false;
    }

    /*
     * Exception decompiling
     */
    private void handleAdd() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ClassInfo createInfo(String className) {
        ClassInfo info = new ClassInfo();
        info.className = className;
        if (className.length() == 0) {
            info.message = Messages.ValidationUiContentProvider_noClass;
        } else {
            if (className.startsWith("{") && className.endsWith("}")) {
                return info;
            }
            try {
                Class<?> testClass = this.loadClass(className);
                int modifiers = testClass.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    info.message = Messages.ValidationUiContentProvider_notPublicClass;
                    return info;
                }
                if (Modifier.isAbstract(modifiers)) {
                    info.message = Messages.ValidationUiContentProvider_abstractClass;
                    return info;
                }
                boolean noConstructor = true;
                try {
                    testClass.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY);
                    noConstructor = false;
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (noConstructor) {
                    info.message = String.valueOf(Messages.ValidationUiContentProvider_noPublicConstructor) + ClassUtils.getShortClassName((String)className) + "().";
                }
            }
            catch (ClassNotFoundException e) {
                info.message = Messages.ValidationUiContentProvider_notExistClass;
            }
        }
        return info;
    }

    private void calculateFinish() {
        int size = this.m_dialogField.getSize();
        int i = 0;
        while (i < size) {
            ClassInfo info = (ClassInfo)this.m_dialogField.getElement(i);
            if (info.message != null) {
                this.setErrorMessage(info.message);
                return;
            }
            ++i;
        }
        this.setErrorMessage(null);
    }

    public void updateFromObject() throws Exception {
        ArrayList infos = Lists.newArrayList();
        for (String className : this.m_validator.getClassNames()) {
            infos.add(this.createInfo(className));
        }
        this.m_dialogField.setElements((Collection)infos);
        this.m_dialogField.setDialogFieldListener(this.m_changeListener);
    }

    public void saveToObject() throws Exception {
        ArrayList classNames = Lists.newArrayList();
        int size = this.m_dialogField.getSize();
        int i = 0;
        while (i < size) {
            ClassInfo info = (ClassInfo)this.m_dialogField.getElement(i);
            classNames.add(info.className);
            ++i;
        }
        this.m_validator.setClassNames(classNames);
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        return CoreUtils.load((ClassLoader)this.m_provider.getXmlObjectRoot().getContext().getClassLoader(), (String)className);
    }

    protected IJavaProject getJavaProject() {
        return this.m_provider.getXmlObjectRoot().getContext().getJavaProject();
    }

    private static class ClassInfo {
        String message;
        String className;

        private ClassInfo() {
        }
    }

    private static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            ClassInfo info = (ClassInfo)element;
            return info.message == null ? CLASS_IMAGE : ERROR_IMAGE;
        }

        public String getText(Object element) {
            ClassInfo info = (ClassInfo)element;
            return info.className;
        }
    }
}

