/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.views;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.wb.internal.core.editor.DesignComposite;
import org.eclipse.wb.internal.core.views.IDesignCompositeProvider;

public abstract class AbstractExtractableDesignView
extends PageBookView {
    private final Map<IWorkbenchPart, DesignComposite.IExtractableControl> m_extractableControls = Maps.newHashMap();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.hookIntoWorkbench();
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] editorReferences;
                IWorkbenchPage activePage = AbstractExtractableDesignView.this.getSite().getWorkbenchWindow().getActivePage();
                IWorkbenchPart activePart = activePage.getActivePart();
                IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editor = editorReference.getEditor(false);
                    if (AbstractExtractableDesignView.this.isImportant((IWorkbenchPart)editor)) {
                        AbstractExtractableDesignView.this.partActivated((IWorkbenchPart)editor);
                    }
                    ++n2;
                }
                AbstractExtractableDesignView.this.partActivated(activePart);
            }
        });
    }

    private void hookIntoWorkbench() {
        final IWorkbenchPage page = this.getSite().getPage();
        final IPartListener2 partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (!this.isEditorMaximized()) {
                    AbstractExtractableDesignView.this.doExtract();
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (this.isEditorMaximized()) {
                            AbstractExtractableDesignView.this.doRestore();
                        }
                    }
                });
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractExtractableDesignView.this) {
                    AbstractExtractableDesignView.this.doRestore();
                }
            }

            private boolean isEditorMaximized() {
                IEditorReference[] editorReferences;
                IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    if (page.getPartState((IWorkbenchPartReference)editorReference) == 1) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        page.addPartListener(partListener);
        this.getPageBook().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                page.removePartListener(partListener);
            }
        });
    }

    private void doExtract() {
        for (DesignComposite.IExtractableControl extractableControl : this.m_extractableControls.values()) {
            extractableControl.extract((Composite)this.getPageBook());
        }
    }

    private void doRestore() {
        for (DesignComposite.IExtractableControl extractableControl : this.m_extractableControls.values()) {
            extractableControl.restore();
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IDesignCompositeProvider provider = (IDesignCompositeProvider)part;
        DesignComposite designComposite = provider.getDesignComposite();
        final DesignComposite.IExtractableControl extractableControl = this.getExtractableControl(designComposite);
        this.m_extractableControls.put(part, extractableControl);
        final Control extractedControl = extractableControl.getControl();
        Page page = new Page(){

            public void createControl(Composite parent) {
                extractableControl.extract(parent);
            }

            public Control getControl() {
                return extractedControl.getParent() == AbstractExtractableDesignView.this.getPageBook() ? extractedControl : null;
            }

            public void setFocus() {
                extractedControl.setFocus();
            }
        };
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        this.m_extractableControls.remove(part);
    }

    protected IWorkbenchPart getBootstrapPart() {
        return this.getSite().getPage().getActiveEditor();
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IDesignCompositeProvider;
    }

    protected abstract DesignComposite.IExtractableControl getExtractableControl(DesignComposite var1);
}

