/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.xml;

import java.io.StringReader;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentHandler;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;
import org.eclipse.wb.internal.core.utils.xml.DocumentTextNode;
import org.eclipse.wb.internal.core.utils.xml.IModelChangedListener;
import org.eclipse.wb.internal.core.utils.xml.ModelChangedEvent;
import org.eclipse.wb.internal.core.utils.xml.parser.QParser;

public abstract class AbstractDocumentEditContext {
    private IDocument m_bufferDocument;
    private IDocument m_document;
    private DocumentElement m_root;
    private final IModelChangedListener m_modelChangedListener = new IModelChangedListener(){

        @Override
        public void modelChanged(final ModelChangedEvent event) {
            ExecutionUtils.runRethrow(new RunnableEx(){

                @Override
                public void run() throws Exception {
                    AbstractDocumentEditContext.this.handleModelChange(event);
                }
            });
        }
    };

    protected final void parse(IDocument bufferDocument) throws Exception {
        this.m_bufferDocument = bufferDocument;
        this.m_document = new Document(this.m_bufferDocument.get());
        AbstractDocumentHandler documentHandler = this.createDocumentHandler();
        try (StringReader reader = new StringReader(this.m_document.get());){
            try {
                QParser.parse(reader, documentHandler);
                this.m_root = documentHandler.getRootNode();
            }
            catch (Throwable e) {
                this.disconnect();
                throw ReflectionUtils.propagate(e);
            }
        }
        this.m_root.getModel().addModelChangedListener(this.m_modelChangedListener);
    }

    public void commit() throws Exception {
        String oldContent;
        String newContent = this.m_document.get();
        if (!newContent.equals(oldContent = this.m_bufferDocument.get())) {
            int[] intervals = StringUtilities.getDifferenceIntervals(oldContent, newContent);
            this.m_bufferDocument.replace(intervals[0], intervals[1], newContent.substring(intervals[2], intervals[2] + intervals[3]));
        }
    }

    public void disconnect() throws CoreException {
        if (this.m_root != null) {
            this.m_root.getModel().removeModelChangedListener(this.m_modelChangedListener);
        }
    }

    public final DocumentElement getRoot() {
        return this.m_root;
    }

    public final String getText() {
        return this.m_document.get();
    }

    public final String getText(final int offset, final int length) {
        return ExecutionUtils.runObject(new RunnableObjectEx<String>(){

            @Override
            public String runObject() throws Exception {
                return AbstractDocumentEditContext.this.m_document.get(offset, length);
            }
        }, "Can not get offset:%d length:%d", offset, length);
    }

    protected AbstractDocumentHandler createDocumentHandler() {
        return new AbstractDocumentHandler();
    }

    private void handleModelChange(ModelChangedEvent event) throws Exception {
        int type = event.getChangeType();
        Object changedObject = event.getChangedObject();
        if (type == 4) {
            if (changedObject instanceof DocumentElement) {
                if (event.getChangedProperty() == "P_XML_TAG_NAME") {
                    DocumentElement element = (DocumentElement)changedObject;
                    String oldXMLTagName = (String)event.getOldValue();
                    this.handleNodeRename(element, oldXMLTagName);
                } else {
                    this.handleAttributeChange(event);
                }
            } else if (changedObject instanceof DocumentTextNode) {
                DocumentTextNode textNode = (DocumentTextNode)changedObject;
                this.handleTextChange(textNode);
            }
        } else if (type == 1) {
            if (changedObject instanceof DocumentElement) {
                DocumentElement element = (DocumentElement)changedObject;
                this.handleNodeInsert(element);
            } else if (changedObject instanceof DocumentAttribute) {
                DocumentAttribute attribute = (DocumentAttribute)changedObject;
                this.handleAttributeInsert(attribute);
            } else if (changedObject instanceof DocumentTextNode) {
                DocumentTextNode textNode = (DocumentTextNode)changedObject;
                this.handleTextInsert(textNode);
            }
        } else if (type == 2) {
            if (changedObject instanceof DocumentElement) {
                DocumentElement oldParent = (DocumentElement)event.getOldValue();
                DocumentElement newParent = (DocumentElement)event.getNewValue();
                DocumentElement element = (DocumentElement)changedObject;
                int position = Integer.parseInt(event.getChangedProperty());
                this.handleNodeMove(element, oldParent, newParent, position);
            }
        } else if (type == 3) {
            if (changedObject instanceof DocumentElement) {
                DocumentElement element = (DocumentElement)changedObject;
                this.handleNodeDelete(element);
            } else if (changedObject instanceof DocumentAttribute) {
                DocumentAttribute attribute = (DocumentAttribute)changedObject;
                this.handleAttributeDelete(attribute);
            } else if (changedObject instanceof DocumentTextNode) {
                DocumentTextNode textNode = (DocumentTextNode)changedObject;
                this.handleTextDelete(textNode);
            }
        }
    }

    private void handleNodeDelete(DocumentElement element) throws Exception {
        int stringStartIndex = this.getElementSourceOffset(element);
        int length = element.getOffset() + element.getLength() - stringStartIndex;
        this.replaceString(stringStartIndex, length, "");
        this.closeIfNoChildren(element.getParent());
    }

    private String getLineIndent(DocumentElement element) throws Exception {
        int end;
        int start = end = element.getOffset();
        while (start != 0) {
            char c = this.m_document.getChar(start - 1);
            if (!Character.isWhitespace(c) || c == '\r' || c == '\n') break;
            --start;
        }
        return this.m_document.get(start, end - start);
    }

    private void handleNodeRename(DocumentElement element, String oldXMLTagName) throws Exception {
        this.replaceString(element.getOffset() + 1, oldXMLTagName.length(), element.getTag());
        if (!element.isClosed()) {
            this.replaceString(element.getCloseTagOffset() + 2, oldXMLTagName.length(), element.getTag());
        }
    }

    private void handleNodeInsert(DocumentElement element) throws Exception {
        DocumentElement parentNode = element.getParent();
        this.ensureElementOpen(parentNode);
        TargetInformation targetInfo = this.prepareTargetInformation(parentNode, parentNode.indexOf(element));
        int baseOffset = targetInfo.offset;
        String prefix = targetInfo.prefix;
        String text = "<" + element.getTag() + "/>";
        this.replaceString(baseOffset, 0, String.valueOf(prefix) + text);
        int offset = baseOffset + prefix.length();
        element.setOffset(offset);
        element.setLength(text.length());
        element.setClosed(true);
    }

    private void closeIfNoChildren(DocumentElement element) throws Exception {
        if (element.getChildren().isEmpty() && element.getTextNode() == null) {
            int begin = element.getOpenTagOffset() + element.getOpenTagLength() - 1;
            int end = element.getCloseTagOffset() + element.getCloseTagLength();
            this.replaceString(begin, end - begin, "/>");
            element.setClosed(true);
        }
    }

    private void ensureElementOpen(DocumentElement element) throws Exception {
        if (!element.isClosed()) {
            return;
        }
        int oldLength = element.getLength();
        int end = element.getOffset() + oldLength;
        int line = this.m_document.getLineOfOffset(end);
        String lineDelimiter = this.m_document.getLineDelimiter(line);
        if (lineDelimiter == null) {
            lineDelimiter = "\n";
        }
        String closeTagReplacement = String.valueOf(lineDelimiter) + this.getLineIndent(element) + "</" + element.getTag() + ">";
        this.replaceString(end, 0, closeTagReplacement);
        this.replaceString(end - 2, 2, ">");
        element.setLength(oldLength + closeTagReplacement.length() - 1);
        AbstractDocumentEditContext.updateOpenCloseTags(element, end);
    }

    private TargetInformation prepareTargetInformation(DocumentElement parentNode, int index) throws Exception {
        String indent;
        int baseOffset;
        if (index == 0) {
            baseOffset = parentNode.getOpenTagOffset() + parentNode.getOpenTagLength();
            indent = String.valueOf(this.getLineIndent(parentNode)) + "\t";
        } else {
            DocumentElement previousChild = parentNode.getChildAt(index - 1);
            baseOffset = previousChild.getOffset() + previousChild.getLength();
            indent = this.getLineIndent(previousChild);
        }
        int line = this.m_document.getLineOfOffset(baseOffset);
        String lineDelimiter = this.m_document.getLineDelimiter(line);
        String prefix = lineDelimiter == null ? "" : String.valueOf(lineDelimiter) + indent;
        TargetInformation target = new TargetInformation();
        target.offset = baseOffset;
        target.prefix = prefix;
        return target;
    }

    private void handleNodeMove(DocumentElement element, DocumentElement oldParent, DocumentElement newParent, int index) throws Exception {
        int oldIndex = oldParent.indexOf(element);
        oldParent.m_children.remove(element);
        if (newParent == oldParent && oldIndex < index) {
            --index;
        }
        int beginOffset = this.getElementSourceOffset(element);
        int endOffset = element.getOffset() + element.getLength();
        String elementString = this.m_document.get(beginOffset, endOffset - beginOffset);
        elementString = StringUtils.stripStart((String)elementString, null);
        this.replaceString(beginOffset, endOffset - beginOffset, "");
        this.ensureElementOpen(newParent);
        TargetInformation targetInfo = this.prepareTargetInformation(newParent, index);
        String prefix = targetInfo.prefix;
        int newOffset = targetInfo.offset;
        this.replaceString(newOffset, 0, prefix);
        this.replaceString(newOffset += prefix.length(), 0, elementString);
        newParent.m_children.add(index, element);
        element.setParent(newParent);
        this.moveElementOffsets(element, newOffset - element.getOffset());
        this.closeIfNoChildren(oldParent);
    }

    private int getElementSourceOffset(DocumentElement element) throws Exception {
        char c;
        DocumentTextNode textNode;
        int offset;
        for (offset = element.getOffset(); ((textNode = element.getParent().getTextNode()) == null || textNode.getOffset() > offset || offset > textNode.getOffset() + textNode.getLength()) && Character.isWhitespace(c = this.m_document.getChar(offset - 1)); --offset) {
        }
        return offset;
    }

    private void moveElementOffsets(DocumentElement start, final int delta) {
        start.accept(new DocumentModelVisitor(){

            @Override
            public void endVisit(DocumentElement element) {
                element.setOffset(element.getOffset() + delta);
                if (!element.isClosed()) {
                    element.setOpenTagOffset(element.getOpenTagOffset() + delta);
                    element.setCloseTagOffset(element.getCloseTagOffset() + delta);
                }
            }

            @Override
            public void visit(DocumentAttribute attribute) {
                attribute.setNameOffset(attribute.getNameOffset() + delta);
                attribute.setValueOffset(attribute.getValueOffset() + delta);
            }

            @Override
            public void visit(DocumentTextNode node) {
                node.setOffset(node.getOffset() + delta);
            }
        });
    }

    private void handleAttributeChange(ModelChangedEvent event) throws Exception {
        DocumentElement element = (DocumentElement)event.getChangedObject();
        DocumentAttribute attribute = element.getDocumentAttribute(event.getChangedProperty());
        int offset = attribute.getValueOffset();
        int length = attribute.getValueLength();
        String newValue = (String)event.getNewValue();
        this.replaceString(offset, length, newValue);
    }

    private void handleAttributeInsert(DocumentAttribute attribute) throws Exception {
        DocumentElement element = attribute.getEnclosingElement();
        DocumentAttribute lastAttribute = null;
        for (DocumentAttribute existingAttribute : element.getDocumentAttributes()) {
            if (existingAttribute == attribute) continue;
            lastAttribute = existingAttribute;
        }
        int offset = lastAttribute == null ? element.getOffset() + element.getTag().length() + 1 : lastAttribute.getValueOffset() + lastAttribute.getValueLength() + 1;
        this.replaceString(offset, 0, " ");
        String assignOpen = "=\"";
        String assignClose = "\"";
        String text = String.valueOf(attribute.getName()) + assignOpen + attribute.getValue() + assignClose;
        this.replaceString(++offset, 0, text);
        int nameLength = attribute.getName().length();
        attribute.setNameOffset(offset);
        attribute.setNameLength(nameLength);
        attribute.setValueOffset(offset + nameLength + assignOpen.length());
        attribute.setValueLength(attribute.getValue().length());
    }

    private void handleAttributeDelete(DocumentAttribute attribute) throws Exception {
        int stringStartIndex = attribute.getNameOffset();
        while (Character.isWhitespace(this.m_document.getChar(stringStartIndex - 1))) {
            --stringStartIndex;
        }
        int length = attribute.getValueOffset() + attribute.getValueLength() + 1 - stringStartIndex;
        this.replaceString(stringStartIndex, length, "");
    }

    private void handleTextChange(DocumentTextNode textNode) throws Exception {
        int offset = textNode.getOffset();
        int length = textNode.getLength();
        String text = textNode.getRawText();
        this.replaceString(offset, length, text);
    }

    private void handleTextInsert(DocumentTextNode textNode) throws Exception {
        DocumentElement parentElement = textNode.getEnclosingElement();
        if (parentElement.isClosed()) {
            int oldLength = parentElement.getLength();
            String closeTagReplacement = "</" + parentElement.getTag() + ">";
            int parentEnd = parentElement.getOffset() + oldLength;
            this.replaceString(parentEnd, 0, closeTagReplacement);
            this.replaceString(parentEnd - 2, 2, ">");
            parentElement.setLength(oldLength + closeTagReplacement.length() - 1);
            AbstractDocumentEditContext.updateOpenCloseTags(parentElement, parentEnd);
        }
        int startOffset = parentElement.getOpenTagOffset() + parentElement.getOpenTagLength();
        int oldLength = parentElement.getCloseTagOffset() - startOffset;
        String text = textNode.getRawText();
        this.replaceString(startOffset, oldLength, text);
        textNode.setOffset(startOffset);
        textNode.setLength(text.length());
    }

    private void handleTextDelete(DocumentTextNode textNode) throws Exception {
        this.replaceString(textNode.getOffset(), textNode.getLength(), "");
        this.closeIfNoChildren(textNode.getEnclosingElement());
    }

    private static void updateOpenCloseTags(DocumentElement parentNode, int parentEnd) {
        parentNode.setClosed(false);
        parentNode.setOpenTagOffset(parentNode.getOffset());
        parentNode.setOpenTagLength(parentEnd - 1 - parentNode.getOffset());
        parentNode.setCloseTagLength(parentNode.getTag().length() + 3);
        parentNode.setCloseTagOffset(parentNode.getOffset() + parentNode.getLength() - parentNode.getCloseTagLength());
    }

    private void replaceString(final int start, int oldLength, String replacement) throws Exception {
        this.m_document.replace(start, oldLength, replacement);
        int newLength = replacement.length();
        final int difference = newLength - oldLength;
        if (difference != 0) {
            final int oldEnd = start + oldLength;
            this.m_root.accept(new DocumentModelVisitor(){

                @Override
                public void endVisit(DocumentElement element) {
                    Position position = this.updatePosition(element.getOffset(), element.getLength());
                    element.setOffset(position.offset);
                    element.setLength(position.length);
                    if (!element.isClosed()) {
                        int openTagOffset = element.getOpenTagOffset();
                        int openTagLength = element.getOpenTagLength();
                        if (openTagOffset < start && oldEnd < openTagOffset + openTagLength) {
                            element.setOpenTagLength(openTagLength + difference);
                        }
                        element.setOpenTagOffset(position.offset);
                        int closeTagOffset = element.getCloseTagOffset();
                        if (start <= closeTagOffset) {
                            element.setCloseTagOffset(closeTagOffset + difference);
                        } else {
                            element.setCloseTagLength(position.offset + position.length - closeTagOffset);
                        }
                    }
                }

                @Override
                public void visit(DocumentAttribute attribute) {
                    Position position = this.updatePosition(attribute.getNameOffset(), attribute.getNameLength());
                    attribute.setNameOffset(position.offset);
                    attribute.setNameLength(position.length);
                    position = this.updatePosition(attribute.getValueOffset(), attribute.getValueLength());
                    attribute.setValueOffset(position.offset);
                    attribute.setValueLength(position.length);
                }

                @Override
                public void visit(DocumentTextNode node) {
                    Position position = this.updatePosition(node.getOffset(), node.getLength());
                    node.setOffset(position.offset);
                    node.setLength(position.length);
                }

                private Position updatePosition(int offset, int length) {
                    Position position = new Position(offset, length);
                    if (offset == start && length == 0) {
                        position.length += difference;
                        return position;
                    }
                    if (offset + length <= start) {
                        return position;
                    }
                    if (offset >= oldEnd) {
                        position.offset += difference;
                        return position;
                    }
                    Assert.isTrue(offset <= start);
                    position.length += difference;
                    return position;
                }
            });
        }
    }

    private static class TargetInformation {
        int offset;
        String prefix;

        private TargetInformation() {
        }
    }
}

