/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.core.controls.CComboBox;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public abstract class AbstractComboBoxPropertyEditor
extends TextDisplayPropertyEditor {
    private CComboBox m_combo;
    private String m_dropDelayedText;

    @Override
    public final boolean activate(final PropertyTable propertyTable, final Property property, Point location) throws Exception {
        this.m_combo = new CComboBox((Composite)propertyTable, 0);
        this.addItems(property, this.m_combo);
        this.selectItem(property, this.m_combo);
        this.m_combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractComboBoxPropertyEditor.this.handleKeyPressed(propertyTable, property, e);
            }
        });
        this.m_combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                propertyTable.deactivateEditor(true);
            }
        });
        this.m_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyTable.deactivateEditor(true);
            }
        });
        this.m_combo.setFocus();
        ExecutionUtils.runAsync(new RunnableEx(){

            @Override
            public void run() throws Exception {
                AbstractComboBoxPropertyEditor.this.m_combo.comboDropDown(true);
                if (AbstractComboBoxPropertyEditor.this.m_dropDelayedText != null) {
                    AbstractComboBoxPropertyEditor.this.m_combo.setEditText(AbstractComboBoxPropertyEditor.this.m_dropDelayedText);
                    AbstractComboBoxPropertyEditor.this.m_combo.setEditSelection(AbstractComboBoxPropertyEditor.this.m_dropDelayedText.length(), AbstractComboBoxPropertyEditor.this.m_dropDelayedText.length());
                    AbstractComboBoxPropertyEditor.this.m_dropDelayedText = null;
                }
            }
        });
        return true;
    }

    private void handleKeyPressed(PropertyTable propertyTable, Property property, KeyEvent e) {
        if (e.keyCode == 27) {
            propertyTable.deactivateEditor(false);
        } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
            e.doit = false;
            propertyTable.deactivateEditor(true);
            propertyTable.navigate(e);
        }
    }

    @Override
    public final void deactivate(PropertyTable propertyTable, Property property, boolean save) {
        if (save) {
            this.toProperty(propertyTable, property);
        }
        if (this.m_combo != null) {
            this.m_combo.dispose();
            this.m_combo = null;
        }
    }

    private void toProperty(PropertyTable propertyTable, Property property) {
        try {
            this.toPropertyEx(property, this.m_combo);
        }
        catch (Throwable e) {
            propertyTable.handleException(e);
        }
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.m_combo.setBounds(bounds);
    }

    @Override
    public void keyDown(PropertyTable propertyTable, Property property, KeyEvent event) throws Exception {
        boolean withCtrl;
        boolean withAlt = (event.stateMask & 0x10000) != 0;
        boolean bl = withCtrl = (event.stateMask & 0x40000) != 0;
        if (event.character > ' ' && !withAlt && !withCtrl) {
            propertyTable.activateEditor(property, null);
            this.m_dropDelayedText = "" + event.character;
        }
    }

    protected abstract void addItems(Property var1, CComboBox var2) throws Exception;

    protected void selectItem(Property property, CComboBox combo) throws Exception {
    }

    protected abstract void toPropertyEx(Property var1, CComboBox var2) throws Exception;
}

