/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import org.apache.commons.lang.ObjectUtils;
import org.eclipse.wb.internal.core.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterDescription
extends AbstractDescription {
    private int m_index;
    private String m_name;
    private Class<?> m_type;
    private boolean m_parent;
    private boolean m_child;
    private boolean m_parent2;
    private boolean m_child2;
    private String m_property;
    private ExpressionConverter m_converter;
    private ExpressionConverter m_converterDefault;
    private PropertyEditor m_editor;
    private PropertyEditor m_editorDefault;
    private String m_defaultSource;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(this.m_type.getName());
        if (this.m_parent) {
            sb.append(",parent");
        }
        if (this.m_child) {
            sb.append(",child");
        }
        if (this.m_parent2) {
            sb.append(",parent2");
        }
        if (this.m_child2) {
            sb.append(",child2");
        }
        sb.append("}");
        return sb.toString();
    }

    public void join(ParameterDescription description) {
        this.m_name = (String)ObjectUtils.defaultIfNull((Object)this.m_name, (Object)description.m_name);
        if (description.m_editor != null) {
            this.m_converter = description.m_converter;
            this.m_editor = description.m_editor;
        }
        this.putTags(description.getTags());
        this.m_property = description.m_property;
        this.m_defaultSource = description.m_defaultSource;
        this.m_parent = description.m_parent;
        this.m_child = description.m_child;
        this.m_parent2 = description.m_parent2;
        this.m_child2 = description.m_child2;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Class<?> getType() {
        return this.m_type;
    }

    public void setType(Class<?> type) throws Exception {
        this.m_type = type;
        this.m_converterDefault = DescriptionPropertiesHelper.getConverterForType(this.m_type);
        this.m_editorDefault = DescriptionPropertiesHelper.getEditorForType(this.m_type);
        this.m_defaultSource = AstParser.getDefaultValue(this.m_type.getName());
    }

    public boolean isParent() {
        return this.m_parent;
    }

    public void setParent(boolean parent) {
        this.m_parent = parent;
    }

    public boolean isChild() {
        return this.m_child;
    }

    public void setChild(boolean child) {
        this.m_child = child;
    }

    public boolean isParent2() {
        return this.m_parent2;
    }

    public void setParent2(boolean parent2) {
        this.m_parent2 = parent2;
    }

    public boolean isChild2() {
        return this.m_child2;
    }

    public void setChild2(boolean child2) {
        this.m_child2 = child2;
    }

    public String getProperty() {
        return this.m_property;
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public ExpressionConverter getConverter() {
        return this.m_converter != null ? this.m_converter : this.m_converterDefault;
    }

    public void setEditor(PropertyEditor editor) {
        this.m_editor = editor;
    }

    public PropertyEditor getEditor() {
        return this.m_editor != null ? this.m_editor : this.m_editorDefault;
    }

    public String getDefaultSource() {
        return this.m_defaultSource;
    }

    public void setDefaultSource(String defaultSource) {
        this.m_defaultSource = defaultSource;
    }
}

