/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.multi;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.core.editor.IEditorPage;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.multi.DefaultMultiMode;
import org.eclipse.wb.internal.core.editor.multi.DesignerEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

final class MultiSplitMode
extends DefaultMultiMode {
    private SashForm m_sashForm;

    public MultiSplitMode(DesignerEditor editor) {
        super(editor);
    }

    void setFocus() {
        this.m_sashForm.setFocus();
    }

    public void showSource() {
        this.showPage(this.m_sourcePage);
    }

    public void showDesign() {
        if (this.m_sourcePage.isActive() || this.m_activePage != null && this.m_activePage != this.m_designPage) {
            if (this.m_additionalPages.isEmpty()) {
                this.m_designPage.setFocus();
            } else {
                this.showPage(this.m_designPage);
            }
        }
    }

    public void switchSourceDesign() {
        if (this.m_sourcePage.isActive()) {
            this.showPage(this.m_designPage);
        } else {
            this.showPage(this.m_sourcePage);
        }
    }

    public void onSetInput() {
    }

    public void create(Composite parent) {
        super.create(parent);
        boolean vertical = this.isSplitVerticalMode();
        this.m_sashForm = new SashForm(parent, vertical ? 512 : 256);
        this.m_sashForm.setBackground(IColorConstants.buttonDarker);
        if (this.isSourceFirst()) {
            this.createSource();
            this.createDesign();
            this.m_sashForm.setWeights(new int[]{40, 60});
        } else {
            this.createDesign();
            this.createSource();
            this.m_sashForm.setWeights(new int[]{60, 40});
        }
        this.m_designPage.setShowProgress(false);
        this.m_designPage.refreshGEF();
        this.parseOnDocumentChange();
        this.trackSourceActivation();
    }

    private void createDesign() {
        if (this.m_additionalPages.isEmpty()) {
            this.m_designPage.createControl((Composite)this.m_sashForm);
        } else {
            this.createTabFolder((Composite)this.m_sashForm);
            this.createTab(this.m_designPage);
            for (IEditorPage page : this.m_additionalPages) {
                this.createTab(page);
            }
        }
    }

    private void createSource() {
        this.m_sourcePage.createControl((Composite)this.m_sashForm);
    }

    private void trackSourceActivation() {
        final Composite sourceControl = (Composite)this.m_sourcePage.getControl();
        final Composite designControl = (Composite)this.m_designPage.getControl();
        final Display display = sourceControl.getDisplay();
        display.addFilter(3, new Listener(){

            public void handleEvent(Event event) {
                if (sourceControl.isDisposed()) {
                    display.removeFilter(3, (Listener)this);
                    return;
                }
                if (UiUtils.isChildOf((Widget)sourceControl, (Widget)event.widget)) {
                    MultiSplitMode.this.showPage(MultiSplitMode.this.m_sourcePage);
                }
                if (UiUtils.isChildOf((Widget)designControl, (Widget)event.widget)) {
                    MultiSplitMode.this.showPage(MultiSplitMode.this.m_designPage);
                }
            }
        });
    }

    void editorActivatedFirstTime() {
        this.showSource();
        this.showDesign();
    }

    private void parseOnDocumentChange() {
        this.m_editor.super_getSourceViewer().getDocument().addDocumentListener(new IDocumentListener(){
            private int m_lastModificationId;

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                final int modificationId = ++this.m_lastModificationId;
                int delay = MultiSplitMode.this.getSyncDelay();
                if (delay > 0) {
                    delay = Math.max(delay, 250);
                    Display.getCurrent().timerExec(delay, new Runnable(){

                        public void run() {
                            if (modificationId == m_lastModificationId && (this).MultiSplitMode.this.m_sourcePage.isActive()) {
                                MultiSplitMode.this.parseWhenSourceActive();
                            }
                        }
                    });
                }
            }
        });
    }

    private void parseWhenSourceActive() {
        try {
            this.m_designPage.refreshGEF();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void afterSave() {
        super.afterSave();
        if (this.getSyncDelay() <= 0) {
            this.parseWhenSourceActive();
        }
    }

    private boolean isSourceFirst() {
        int layout = DesignerPlugin.getPreferences().getInt("editor.layout");
        return layout == 5 || layout == 4;
    }

    private boolean isSplitVerticalMode() {
        int layout = DesignerPlugin.getPreferences().getInt("editor.layout");
        return layout == 4 || layout == 2;
    }

    private int getSyncDelay() {
        return DesignerPlugin.getPreferences().getInt("editor.layout.syncDelay");
    }
}

