/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.event;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryFilterSemantics;

public class ViatraQueryMultiMatchEventFilter<Match extends IPatternMatch>
implements EventFilter<Match> {
    private Collection<Match> filterMatches;
    private ViatraQueryFilterSemantics semantics;

    public Collection<Match> getFilterMatches() {
        return this.filterMatches;
    }

    @Override
    public boolean isProcessable(Match eventAtom) {
        if (this.filterMatches == null) {
            return true;
        }
        switch (this.semantics) {
            default: {
                for (IPatternMatch filterMatch : this.filterMatches) {
                    if (!filterMatch.isCompatibleWith(eventAtom)) continue;
                    return true;
                }
                return false;
            }
            case AND: 
        }
        for (IPatternMatch filterMatch : this.filterMatches) {
            if (filterMatch.isCompatibleWith(eventAtom)) continue;
            return false;
        }
        return true;
    }

    protected ViatraQueryMultiMatchEventFilter(Collection<Match> filterMatches, ViatraQueryFilterSemantics semantics) {
        Preconditions.checkArgument((filterMatches != null ? 1 : 0) != 0, (String)"Cannot create filter with null matches");
        this.semantics = semantics;
        this.filterMatches = filterMatches;
    }

    public static <Match extends IPatternMatch> ViatraQueryMultiMatchEventFilter<Match> createFilter(Collection<Match> eventAtoms, ViatraQueryFilterSemantics semantics) {
        Preconditions.checkArgument((eventAtoms != null ? 1 : 0) != 0, (String)"Cannot create filter for null match, use createEmptyFilter() instead!");
        for (IPatternMatch eventAtom : eventAtoms) {
            Preconditions.checkArgument((!eventAtom.isMutable() ? 1 : 0) != 0, (String)"Cannot create filter for mutable match!");
        }
        return new ViatraQueryMultiMatchEventFilter<Match>(eventAtoms, semantics);
    }

    public int hashCode() {
        return Objects.hash(this.filterMatches);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViatraQueryMultiMatchEventFilter other = (ViatraQueryMultiMatchEventFilter)obj;
        return Objects.equals(this.filterMatches, other.filterMatches);
    }
}

