/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.event;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.scope.IBaseIndex;
import org.eclipse.viatra.query.runtime.api.scope.IInstanceObserver;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;
import org.eclipse.viatra.transformation.evm.notification.AttributeMonitor;

public class LightweightAttributeMonitor<MatchType extends IPatternMatch>
extends AttributeMonitor<MatchType> {
    private IInstanceObserver observer;
    private IMultiLookup<Object, MatchType> observedMultimap;
    private IBaseIndex index;

    public LightweightAttributeMonitor(IBaseIndex index) {
        this.index = index;
        this.observer = new IInstanceObserver(){

            public void notifyBinaryChanged(Object sourceElement, Object edgeType) {
                IMemoryView matches = LightweightAttributeMonitor.this.observedMultimap.lookupOrEmpty(sourceElement);
                for (IPatternMatch matchType : matches) {
                    LightweightAttributeMonitor.this.notifyListeners(matchType);
                }
            }

            public void notifyTernaryChanged(Object sourceElement, Object edgeType) {
                IMemoryView matches = LightweightAttributeMonitor.this.observedMultimap.lookupOrEmpty(sourceElement);
                for (IPatternMatch matchType : matches) {
                    LightweightAttributeMonitor.this.notifyListeners(matchType);
                }
            }
        };
        this.observedMultimap = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, Object.class);
    }

    @Override
    public void registerFor(MatchType atom) {
        Collection<Object> allObjects = this.findAllObjects(atom);
        for (Object object : allObjects) {
            this.index.addInstanceObserver(this.observer, object);
            this.observedMultimap.addPair(object, atom);
        }
    }

    @Override
    public void unregisterForAll() {
        for (Object eobj : this.observedMultimap.distinctKeys()) {
            this.index.removeInstanceObserver(this.observer, eobj);
        }
    }

    @Override
    public void unregisterFor(MatchType atom) {
        Collection<Object> allObjects = this.findAllObjects(atom);
        for (Object object : allObjects) {
            this.index.removeInstanceObserver(this.observer, object);
            this.observedMultimap.removePair(object, atom);
        }
    }

    private Collection<Object> findAllObjects(MatchType atom) {
        HashSet<Object> objs = new HashSet<Object>();
        for (String param : atom.parameterNames()) {
            Object location = atom.get(param);
            objs.add(location);
        }
        return objs;
    }
}

