/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.notification;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventType;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationListener;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationProvider;

public abstract class ActivationNotificationProvider
implements IActivationNotificationProvider {
    private Set<IActivationNotificationListener> activationNotificationListeners = new HashSet<IActivationNotificationListener>();

    @Override
    public boolean addActivationNotificationListener(IActivationNotificationListener listener, boolean fireNow) {
        boolean notContained = this.activationNotificationListeners.add(listener);
        if (notContained) {
            this.listenerAdded(listener, fireNow);
        }
        return notContained;
    }

    protected abstract void listenerAdded(IActivationNotificationListener var1, boolean var2);

    @Override
    public boolean removeActivationNotificationListener(IActivationNotificationListener listener) {
        return this.activationNotificationListeners.remove(listener);
    }

    public void notifyActivationChanged(Activation<?> activation, ActivationState oldState, EventType event) {
        for (IActivationNotificationListener listener : this.activationNotificationListeners) {
            listener.activationChanged(activation, oldState, event);
        }
    }

    public void notifyActivationCreated(Activation<?> activation, ActivationState inactiveState) {
        for (IActivationNotificationListener listener : this.activationNotificationListeners) {
            listener.activationCreated(activation, inactiveState);
        }
    }

    public void notifyActivationRemoved(Activation<?> activation, ActivationState oldState) {
        for (IActivationNotificationListener listener : this.activationNotificationListeners) {
            listener.activationRemoved(activation, oldState);
        }
    }

    public void dispose() {
        this.activationNotificationListeners.clear();
    }
}

